
<?php $__env->startSection('title', $blog->title); ?>
<?php $__env->startSection('content'); ?>

<?php
    // Parse tags from comma-separated string to array
    $tags = !empty($blog->tags) ? array_map('trim', explode(',', $blog->tags)) : [];
    
    // Get FAQ data - handle different formats
    $faqs = [];
    if (!empty($blog->faq_json)) {
        if (is_array($blog->faq_json)) {
            $faqs = $blog->faq_json;
        } else {
            $decoded = json_decode($blog->faq_json, true);
            $faqs = is_array($decoded) ? $decoded : [];
        }
    }
    
    // Convert FAQ array to simple format if it's in "new_1", "new_2" format
    if (!empty($faqs) && isset($faqs['new_1'])) {
        $faqs = array_values($faqs);
    }
?>

<!--=================|| About Us Sec start ||============================-->
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h2><?php echo e($blog->title, false); ?></h2>
               <div class="card-categories-v3" style="border:unset;">
                  <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <span class="category-tag-v3"><?php echo e($tag, false); ?></span>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <span class="category-tag-v3"><?php echo e($blog->created_at->format('F d, Y'), false); ?></span>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<!--=================|| About Us start ||============================-->

<!--=================|| Blog Content Section ||============================-->
<section class="blog-content-section ptb100">
   <div class="container">
      <div class="blog-content">
         <?php if($blog->feature_image): ?>
         <div class="featured-image">
            <img src="<?php echo e(asset('storage/' . $blog->feature_image), false); ?>" alt="<?php echo e($blog->title, false); ?>" class="img-fluid">
         </div>
         <?php endif; ?>
         
         <?php if(!empty($blog->description)): ?>
         <div class="blog-description">
            <?php echo $blog->description; ?>

         </div>
         <?php endif; ?>
      </div>
   </div>
</section>

<!--=================|| FAQ  start ||============================-->
<?php if(!empty($faqs)): ?>
<section class="faq_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h2>Frequently Asked Questions</h2>
      </div>
      <div class="accordion pt40">
         <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <div class="accordion-item">
            <div class="accordion-header">
               <?php echo e($index + 1, false); ?>. <?php echo e($faq['question'] ?? 'Question', false); ?>

               <span class="icon"><i class="fa-solid fa-plus"></i></span>
            </div>
            <div class="accordion-body" style="display: none;">
               <?php echo isset($faq['answer']) ? nl2br(e($faq['answer'])) : 'Answer not available.'; ?>

            </div>
         </div>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| FAQ  End ||============================-->

<script>
  $(document).ready(function() {
    $('.accordion-header').click(function () {
      const parent = $(this).parent();
      const body = parent.find('.accordion-body');
      const icon = $(this).find('.icon');

      // Close all other bodies and reset their icons
      $('.accordion-item').not(parent).each(function () {
        $(this).find('.accordion-body').slideUp();
        $(this).find('.icon').html('<i class="fa-solid fa-plus"></i>');
      });
      
      // Toggle current body
      body.slideToggle();

      // Toggle icon
      const isOpen = icon.html().includes('fa-plus');
      icon.html(isOpen 
        ? '<i class="fa-solid fa-minus"></i>' 
        : '<i class="fa-solid fa-plus"></i>');
    });
  });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/blog-detail.blade.php ENDPATH**/ ?>