
<?php $__env->startSection('title', $page->name); ?>
<?php $__env->startSection('content'); ?>

<?php
    $pageData = $page->page_json;
?>

<style>
    .founder_sec .founder_left ul li::before {
        content: "";
        background-image: url(../frontend/images/tick.svg);
        background-repeat: no-repeat;
        background-position: center;
        background-size: contain;
        width: 18px;
        height: 18px;
        display: block;
        position: relative;
        top: 23px;
        left: -10px;
    }
    .founder_sec .founder_left ul li::marker {
        content: "";
        background-image: url(../frontend/images/tick.svg);
        background-repeat: no-repeat;
        background-position: center;
        background-size: contain;
        width: 18px;
        height: 18px;
        display: block;
        position: relative;
        top: 3px;
    }
</style>

<!--=================|| About Us Sec start ||============================-->
<section class="about_us_sec pt200 pb100" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
    <div class="container">
        <div class="about_grid">
            <div class="about_left">
                <div class="sec_head">
                    <h5><?php echo e($pageData['sub_heading'] ?? 'About us', false); ?></h5>
                    <h2><?php echo e($pageData['heading'] ?? 'Your go to business consultants.', false); ?></h2>
                    <p><?php echo e($pageData['paragraph'] ?? 'At Topfilings we are dedicated to provide best consultancy services for your business to grow.', false); ?></p>
                </div>
            </div>
            <div class="about_right">
                <div class="count-box">
                    <h2 class="number"><?php echo e($pageData['year_count'] ?? '12', false); ?><span class="suffix">+</span></h2>
                    <span class="text">Years of experience</span>
                </div>
            </div>
        </div>
    </div>
</section>
<!--=================|| About Us start ||============================-->

<!--=================|| Video start ||============================-->
<section class="video_sec">
    <div class="container">
        <video loop muted playsinline autoplay width="100%">
            <source src="<?php echo e(asset('frontend/video/video.mp4'), false); ?>" type="video/mp4">
        </video>
    </div>
</section>
<!--=================|| Video End ||============================-->

<!--=================|| Founder Sec Start ||============================-->
<?php if(isset($pageData['founder_details']) && isset($pageData['current_founder_image'])): ?>
<section class="founder_sec ptb100">
    <div class="container">
        <div class="founder_grid">
            <div class="founder_right">
                <img src="<?php echo e(asset('storage/' . $pageData['current_founder_image']), false); ?>" alt="Founder Image"/>
            </div>
            <div class="founder_left">
                <div class="sec_head">
                    <?php echo $pageData['founder_details']; ?>

                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!--=================|| Founder Sec End ||============================-->

<!--=================|| About icon Start ||============================-->
<section class="icon_sec pb100">
    <div class="container">
        <div class="icon_grid">
            <?php for($i = 0; $i <= 3; $i++): ?>
                <?php if(isset($pageData['card_' . $i])): ?>
                    <?php $card = $pageData['card_' . $i]; ?>
                    <div class="icon_box">
                        <?php if(isset($card['image'])): ?>
                            <img src="<?php echo e(asset('storage/' . $card['image']), false); ?>" alt="<?php echo e($card['title'] ?? 'Icon', false); ?>"/>
                        <?php else: ?>
                            <img src="<?php echo e(asset('images/about-us/icon' . ($i + 1) . '.svg'), false); ?>" alt="<?php echo e($card['title'] ?? 'Icon', false); ?>"/>
                        <?php endif; ?>
                        <h4><?php echo e($card['title'] ?? 'Title', false); ?></h4>
                        <p><?php echo e($card['paragraph'] ?? 'Description', false); ?></p>
                    </div>
                <?php endif; ?>
            <?php endfor; ?>
        </div>
    </div>
</section>
<!--=================|| About icon End ||============================-->

<!--=================|| Counter Sec Start ||============================-->
<section class="counter_sec ptb100" style="background-color: #F6F6F8;">
    <div class="container">
        <div class="counter_img">
            <?php for($i = 0; $i <= 2; $i++): ?>
                <?php if(isset($pageData['section_' . $i])): ?>
                    <?php $section = $pageData['section_' . $i]; ?>
                    <div class="counter_img_box">
                        <img src="<?php echo e(asset('storage/' . $section['image']), false); ?>" alt="<?php echo e($section['title'] ?? 'Image', false); ?>"/>
                        <h3><?php echo e($section['title'] ?? 'Title', false); ?></h3>
                    </div>
                <?php endif; ?>
            <?php endfor; ?>
        </div>
        <div class="counter_grid pt80">
            <div class="counter_boxin">
                <div class="counter_flex">
                    <div class="counter-value" data-count="<?php echo e($pageData['customer_served'] ?? '5000', false); ?>"><?php echo e($pageData['customer_served'] ?? '5000', false); ?></div>
                    <span>+</span>
                </div>
                <h4>Customer Served</h4>
            </div>
            <div class="counter_boxin">
                <div class="counter_flex">
                    <div class="counter-value" data-count="<?php echo e($pageData['successfull_starts'] ?? '500', false); ?>"><?php echo e($pageData['successfull_starts'] ?? '500', false); ?></div>
                    <span>+</span>
                </div>
                <h4>Successful Starts</h4>
            </div>
            <div class="counter_boxin">
                <div class="counter_flex">
                    <div class="counter-value" data-count="<?php echo e($pageData['satisfaction_rate'] ?? '99.9', false); ?>"><?php echo e($pageData['satisfaction_rate'] ?? '99.9', false); ?></div>
                    <span>%</span>
                </div>
                <h4>Satisfaction rate</h4>
            </div>
        </div>
    </div>
</section>
<!--=================|| Counter Sec End ||============================-->

<!--=================|| Our Mission Sec Start ||============================-->
<?php if(isset($pageData['our_mission'])): ?>
<section class="our_mission_sec ptb100">
    <div class="container">
        <div class="our_misson_grid">
            <div class="our_mission_left">
                <div class="sec_head">
                    <h5>Our mission</h5>
                    <h2><?php echo e($pageData['our_mission']['heading'] ?? 'We founded Topfilings to empower business people...', false); ?></h2>
                </div>
                <?php for($i = 0; $i <= 2; $i++): ?>
                    <?php if(isset($pageData['our_mission']['list_' . $i])): ?>
                        <?php $mission = $pageData['our_mission']['list_' . $i]; ?>
                        <div class="mission_box">
                            <div class="mission_img">
                                <i class="<?php echo e($mission['icon'] ?? 'fas fa-rocket', false); ?>" style="color: #0f55dc;"></i>
                            </div>
                            <div class="mission_content">
                                <h3><?php echo e($mission['title'] ?? 'Faster Consultancy Services, for Everyone', false); ?></h3>
                                <p><?php echo e($mission['paragraph'] ?? 'Quick, expert advice tailored to your business needs...', false); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
            <div class="our_mission_right">
                <?php if(isset($pageData['our_mission']['image'])): ?>
                    <img src="<?php echo e(asset('storage/' . $pageData['our_mission']['image']), false); ?>" alt="Our Mission"/>
                <?php else: ?>
                    <img src="<?php echo e(asset('images/slider-2.jpg'), false); ?>" alt="Our Mission"/>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!--=================|| Our Mission Sec End ||============================-->

<!--=================|| Our Team Sec Start ||============================-->
<section class="our_team_sec pb100">
    <div class="container">
        <div class="sec_head center_head pb60">
            <h2>Our Team</h2>
            <p>Partner with Topfilings.com for end-to-end business legal solutions — from company registration and tax filings to intellectual property (IP) registration and ongoing regulatory compliance. We simplify legal complexities so you can focus on growing your business.</p>
        </div>
        <div class="team_slider owl-carousel owl-theme">
            <?php for($i = 0; $i <= 4; $i++): ?>
                <?php if(isset($pageData['team_member_' . $i]['name'])): ?>
                    <?php $member = $pageData['team_member_' . $i]; ?>
                    <div class="team_box item">
                        <div class="team_img">
                            <img src="<?php echo e(asset('storage/' . $member['image']), false); ?>" alt="<?php echo e($member['name'], false); ?>"/>
                        </div>
                        <div class="team_details">
                            <h3><?php echo e($member['name'], false); ?></h3>
                            <p><?php echo e($member['designation'], false); ?></p>
                            <p class="team_description"><?php echo e($member['details'], false); ?></p>
                        </div>
                        <ul class="team_icon">
                            <li>
                                <a href="<?php echo e($member['instagram'] ?? 'javascript:void(0);', false); ?>" target="_blank">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e($member['linked_in'] ?? 'javascript:void(0);', false); ?>" target="_blank">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e($member['whatsapp'] ?? 'javascript:void(0);', false); ?>" target="_blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>
            <?php endfor; ?>
        </div>
    </div>
</section>
<!--=================|| Our Team Sec End ||============================-->

<!--=================|| Logo Sec Start ||============================-->
<?php if(isset($pageData['partners_image'])): ?>
<section class="logo_sec ptb60" style="background-color: #F6F6F8;">
    <div class="container">
        <div class="owl-carousel logo-carousel">
            <?php $__currentLoopData = $pageData['partners_image']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partnerImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img src="<?php echo e(asset('storage/' . $partnerImage), false); ?>" alt="Partner Logo"/>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<!--=================|| Logo Sec End ||============================-->

<!--=================|| Team Popup Start ||============================-->
<div class="teampop_grid">
    <div class="crossbtn">
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="512" height="512" x="0" y="0" viewBox="0 0 329.269 329" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
            <g>
                <path d="M194.8 164.77 323.013 36.555c8.343-8.34 8.343-21.825 0-30.164-8.34-8.34-21.825-8.34-30.164 0L164.633 134.605 36.422 6.391c-8.344-8.34-21.824-8.34-30.164 0-8.344 8.34-8.344 21.824 0 30.164l128.21 128.215L6.259 292.984c-8.344 8.34-8.344 21.825 0 30.164a21.266 21.266 0 0 0 15.082 6.25c5.46 0 10.922-2.09 15.082-6.25l128.21-128.214 128.216 128.214a21.273 21.273 0 0 0 15.082 6.25c5.46 0 10.922-2.09 15.082-6.25 8.343-8.34 8.343-21.824 0-30.164zm0 0" fill="#000000" opacity="1" data-original="#000000"></path>
            </g>
        </svg>
    </div>
    <div class="teampop_box">
        <img src="" alt="team">
    </div>
    <div class="teampop_right">
        <h2></h2>
        <h4></h4>
        <p></p>
    </div>
</div>
<div class="teampop_overlay"></div>
<!--=================|| Team Popup End ||============================-->

<script>
    jQuery(document).ready(function($){
        $('.logo-carousel').owlCarousel({
            loop: true,
            autoplay: true,
            autoplayTimeout: 1500,
            smartSpeed: 1500,
            dots: false,
            nav: false,
            responsive: {
                0: { items: 2 ,  margin: 10,},
                681: { items:3, margin: 15, },
                992: { items: 4, margin: 20, },
                992: { items: 5 ,margin: 30,},
                1281: { items: 5 ,margin: 60,}
            }
        });
        
        $('.team_slider').on('click', '.team_box', function() {
            var imageSrc = $(this).find('.team_img img').attr('src');
            var name = $(this).find('h3').text();
            var position = $(this).find('p:first').text();
            var description = $(this).find('.team_description').text();
            $('.teampop_grid .teampop_box img').attr('src', imageSrc);
            $('.teampop_grid h2').text(name);
            $('.teampop_grid h4').text(position);
            $('.teampop_grid p').text(description);
            $('.teampop_grid').addClass('active');
            $('.teampop_overlay').addClass('active');
        });
        
        $('.crossbtn,.teampop_overlay').on('click', function() {
            $('.teampop_grid').removeClass('active');
            $('.teampop_overlay').removeClass('active');
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/about-us.blade.php ENDPATH**/ ?>