
<?php $__env->startSection('title', $page->name); ?>
<?php $__env->startSection('content'); ?>
<?php
   $contentFormSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
   $whySection = $page->sections->firstWhere('section_name', 'service_why_section');
   $parallaxSection = $page->sections->firstWhere('section_name', 'parallax_section');
   $iconBoxSection = $page->sections->firstWhere('section_name', 'service_icon_box');
   $businessStructureSection = $page->sections->firstWhere('section_name', 'service_business_structure');
   $titleParagraphSection = $page->sections->firstWhere('section_name', 'title_paragraph_card');
   $blogSection = $page->sections->firstWhere('section_name', 'home_blog_section');

   $contentSection = $page->sections->firstWhere('section_name', 'content');
?>

<!--=================|| About Us Sec start ||============================-->
<?php if($contentFormSection): ?>
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5><?php echo e($contentFormSection->section_json['sub_heading'], false); ?></h5>
               <h2><?php echo e($contentFormSection->section_json['heading'], false); ?></h2>
               <p><?php echo e($contentFormSection->section_json['paragraph'], false); ?></p>
               <ul class="hero-features">
                  <?php for($i = 0; $i < 3; $i++): ?>
                     <?php if(!empty($contentFormSection->section_json["list_$i"])): ?>
                     <li><i class="fa-regular fa-circle-check"></i> <?php echo e($contentFormSection->section_json["list_$i"], false); ?></li>
                     <?php endif; ?>
                  <?php endfor; ?>
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form">
               @csrf
               <h3><?php echo e($contentFormSection->section_json['form_heading'], false); ?></h3>
               <p><?php echo e($contentFormSection->section_json['form_sub_heading'], false); ?></p>
               <input type="hidden" name="type" value="<?php echo e($contentFormSection->section_json['form_heading'], false); ?>">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit"><?php echo e($contentFormSection->section_json['form_button_text'], false); ?></button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| About Us start ||============================-->

<!-- paralax -->
<!--=================|| What is a Sole Proprietorship  Start ||============================-->
<?php if($parallaxSection): ?>
<section class="what_sole_sec ptb100" style="background-image: url(storage/<?php echo e($parallaxSection->section_json['background_image'], false); ?>);">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
         <h2><?php echo e($parallaxSection->section_json['heading'], false); ?></h2>
         <p><?php echo e($parallaxSection->section_json['paragraph'], false); ?></p>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================||What is a Sole Proprietorship End ||============================-->

<?php if(request()->is('public-limited-company')): ?>
<!--=================|| Gallery Sec ||============================-->
<section class="gallery_sec ptb100">
   <div class="container">
      <div class="gallery_grid">
         <div class="gallery_box w50">
            <img src="<?php echo e(asset('frontend/images/imgnew2.png'), false); ?>" alt="img" />
            <!-- <h3>Benefits of Public Limited Company Registration</h3> -->
         </div>
         <div class="gallery_box w50">
            <img src="<?php echo e(asset('frontend/images/imgnew1.png'), false); ?>" alt="img" />
            <!-- <h3>Documents Required for Public Limited Company Registration</h3> -->
         </div>
         <div class="gallery_box w100">
            <img src="<?php echo e(asset('frontend/images/topfilings1.png'), false); ?>" alt="img" />
         </div>
      </div>
      <p>Need assistance? Don’t worry, experts are here to help!<br>Call us at:&nbsp;<strong><a href="<?php echo e(getPhoneNumber(), false); ?>" bis_skin_checked="1"><?php echo e(getPhoneNumber(), false); ?></a></strong>&nbsp;or Email us:&nbsp;<strong><a href="mailto:<?php echo e(getEmailAddress(), false); ?>" bis_skin_checked="1"><?php echo e(getEmailAddress(), false); ?></a></strong></p>
   </div>
</section>
<!--=================|| Gallery End ||============================-->
<?php endif; ?>

<!--=================|| Why Private Limited  start ||============================-->
<?php if($whySection && !empty($whySection->section_table)): ?>
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h5><?php echo e($whySection->section_json['sub_heading'], false); ?></h5>
         <h2><?php echo e($whySection->section_json['heading'], false); ?></h2>
      </div>
      <div class="why_grid pt40">
         <?php $__currentLoopData = $whySection->section_table; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_array($item) && !empty($item['title'])): ?>
            <div class="service-box">
               <div class="service-item">
                  <h3 class="xb-item--title"><?php echo e($item['title'], false); ?></h3>
                  <p class="xb-item-contact"><?php echo e($item['paragraph'], false); ?></p>
                  <?php if(!empty($item['icon'])): ?>
                  <div class="xb-item--img">
                     <img loading="lazy" decoding="async" width="640" height="640" src="<?php echo e(asset('storage/' . $item['icon']), false); ?>" class="attachment-full size-full" alt="<?php echo e($item['title'], false); ?>">
                  </div>
                  <?php endif; ?>
               </div>
            </div>
            <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Why Private Limited  End ||============================-->

<!--=================|| Online Company Registration  Start ||============================-->
<?php if($titleParagraphSection && !empty($titleParagraphSection->section_json)): ?>
<section class="document_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2><?php echo e($titleParagraphSection->section_json['heading'], false); ?></h2>
      </div>
      <div class="steps-wrapper pt40">
         <?php for($i = 0; $i <= 6; $i++): ?>
            <?php if(isset($titleParagraphSection->section_json['card_' . $i])): ?>
            <div class="step-item">
               <?php echo $titleParagraphSection->section_json['card_' . $i]; ?>

            </div>
            <?php endif; ?>
         <?php endfor; ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Online Company Registration  End ||============================-->


<!--=================|| Documents Required  Start ||============================-->
<?php if($iconBoxSection && !empty($iconBoxSection->section_table)): ?>
<section class="document_sec ptb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2><?php echo e($iconBoxSection->section_json['heading'], false); ?></h2>
      </div>
      <div class="featured_grid pt40">
         <?php $__currentLoopData = $iconBoxSection->section_table; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_array($item) && !empty($item['title'])): ?>
            <div class="feature-box">
               <div class="icon-container">
                  <?php if(!empty($item['icon'])): ?>
                  <i class="<?php echo e($item['icon'], false); ?>"></i>
                  <?php endif; ?>
               </div>
               <h4><?php echo e($item['title'], false); ?></h4>
               <p><?php echo e($item['paragraph'], false); ?></p>
            </div>
            <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Documents Required  End ||============================-->

<!--=================|| Business Structure Start ||============================-->
<?php if($businessStructureSection && !empty($businessStructureSection->section_table)): ?>
<section class="business_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h5><?php echo e($businessStructureSection->section_json['sub_heading'], false); ?></h5>
         <h2><?php echo e($businessStructureSection->section_json['heading'], false); ?></h2>
      </div>
      <div class="business_table pt40">
         <table>
            <thead>
               <tr>
                  <th></th>
                  <th>Private Limited Company</th>
                  <th>One Person Company</th>
                  <th>Limited Liability Partnership</th>
                  <th>Partnership Firm</th>
                  <th>Proprietorship Firm</th>
               </tr>
            </thead>
            <tbody>
               <?php $__currentLoopData = array_values($businessStructureSection->section_table); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <?php if(isset($item['service'])): ?>
               <tr>
                  <td><?php echo e($item['service'], false); ?></td>
                  <td><?php echo e($item['private_limited_company'], false); ?></td>
                  <td><?php echo e($item['one_person_company'], false); ?></td>
                  <td><?php echo e($item['limited_liability_partnership'], false); ?></td>
                  <td><?php echo e($item['partnership_firm'], false); ?></td>
                  <td><?php echo e($item['proprietorship_firm'], false); ?></td>
               </tr>
               <?php endif; ?>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
         </table>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Business Structure End ||============================-->

<!--=================|| Helpful Resources  Start ||============================-->
<?php if($blogSection): ?>
<section class="helpful_sec ptb100">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
        <h2><?php echo e($blogSection->section_json['heading'], false); ?></h2>
        <p><?php echo e($blogSection->section_json['sub_heading'], false); ?></p>
      </div>
      <div class="helpful_grid pt60">
        <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <a href="<?php echo e(url('/blog/'.$blog->slug), false); ?>" class="inner-box">
        <div class="image-box" bis_skin_checked="1">
            <img src="<?php echo e(asset('storage/'.$blog->feature_image), false); ?>" alt="<?php echo e($blog->slug, false); ?>"/>
        </div>
        <div class="content-box" bis_skin_checked="1">
            <span class="date">
                <?php
                    $created_at = \Carbon\Carbon::parse($blog->created_at)->format('d M Y');
                ?>
                <?php echo e($created_at, false); ?>

            </span>
            <?php if($blog->tags): ?>
            <ul class="post-info">
                <?php
                    $tags = explode(',', $blog->tags);
                ?>
                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($tag, false); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php endif; ?>
            <h4 class="title"><?php echo e($blog->title, false); ?></h4>
        </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Helpful Resources  End ||============================-->


<!-- Banner Section -->
<?php if($contentSection && !empty($contentSection->section_json)): ?>
<section class="about_us_sec pt200 pb100 privacy_banner" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5><?php echo e($contentSection->section_json['sub_heading'], false); ?></h5>
               <h2><?php echo e($contentSection->section_json['heading'], false); ?></h2>
               <h6>Updated on : <?php echo e($page->updated_at->format('F jS, Y'), false); ?></h6>
            </div>
         </div>
      </div>
   </div>
</section>
<?php endif; ?>

<!-- Content Section -->
<?php if($contentSection && !empty($contentSection->section_json['content'])): ?>
<section class="privacy_sec ptb100">
   <div class="container">
      <div class="privacy_grid">
         <div class="privacy_box">
            <?php echo $contentSection->section_json['content']; ?>

         </div>
      </div>
   </div>
</section>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/page.blade.php ENDPATH**/ ?>