<!DOCTYPE html>
<html>
    <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <link rel="icon" href="/favicon.ico" type="image/x-icon">
      <link rel="icon" href="<?php echo e(getFavIcon(), false); ?>">
      <title><?php echo e(env('APP_NAME'), false); ?> | <?php echo $__env->yieldContent('title'); ?></title>
      <!--========|| Css Start ||==========-->
      <link rel="stylesheet" href="https://site-assets.fontawesome.com/releases/v6.7.2/css/all.css">
      <link rel="stylesheet" href="<?php echo e(asset('frontend/css/fonts.css'), false); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('frontend/css/owlcarousel.css'), false); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('frontend/css/owlthemedefault.css'), false); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css'), false); ?>">
      <link rel="stylesheet" href="<?php echo e(asset('frontend/css/responsive.css'), false); ?>">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
      <!--========|| Css End ||==========-->
      <script src="<?php echo e(asset('frontend/js/jquery.js'), false); ?>"></script>
    </head>
    <body>
        <!--=================|| Header Start ||============================-->
        <?php
            $header_nav = App\Http\Controllers\FrontEndController::header();
        ?>
        <?php if(filled($header_nav) and $header_nav->value !== null): ?>
            <?php
                $header_nav = $header_nav->value;
            ?>
            <header class="header">
                <div class="menu_overlay"></div>
                <div class="header_inner">
                    <a href="/" class="logo">
                    <img src="<?php echo e(getSiteLogo(), false); ?>" alt="icon" width="167px"/>
                    </a>
                    <div class="nav_menu">
                        <a href="/" class="logo moblie_logo">
                        <img src="<?php echo e(getSiteLogo(), false); ?>" alt="icon" width="167px"/>
                        </a>
                        <span class="cross"><i class="fa-regular fa-xmark"></i></span>
                        <!-- <nav>
                            <ul>
                                <li><a href="index.php" class="active" bis_skin_checked="1">Home</a></li>
                                <li class="drop_down">
                                    <a href="javascript:void(0);" bis_skin_checked="1">Start a Business</a>
                                    <ul class="mobile_menu">
                                    <li data-list="1" class="active">
                                        <a href="javascript:void(0);" bis_skin_checked="1">
                                        Most Demanded <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="private-limited-registration.php"> Private Limited Registration</a></li>
                                            <li><a href="public-limited-company-registration.php"> Public Limited Company</a></li>
                                            <li><a href="llp-registration.php"> LLP Registration</a></li>
                                            <li><a href="partnership-firm-registration.php"> Partnership Firm Registration</a></li>
                                            <li><a href="llp-registration.php"> One Person Company Registration</a></li>
                                            <li><a href="register-sole-proprietorship-firm-in-india.php"> Sole Proprietorship Firm</a></li>
                                        </ul>
                                    </li>
                                    <li data-list="2" class="">
                                        <a href="javascript:void(0);" bis_skin_checked="1"> Special Business Types  <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="foreign-company-registration-in-india.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon6.svg'), false); ?>" alt="icon"> Foreign Company Registration</a></li>
                                            <li><a href="online-trust-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon7.svg'), false); ?>" alt="icon"> Trust Registration</a></li>
                                            <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon8.svg'), false); ?>" alt="icon"> Section 8 Company Registration</a></li>
                                        </ul>
                                    </li>
                                    </ul>
                                    <div class="submenu" bis_skin_checked="1">
                                    <div class="submenu_left" bis_skin_checked="1">
                                        <ul>
                                            <li data-list="1" class="">
                                                <a href="javascript:void(0);" bis_skin_checked="1">
                                                <img src="<?php echo e(asset('frontend/images/menu_icon/icon1.svg'), false); ?>" alt="icon">  Most Demanded  <i class="fa-regular fa-chevron-right"></i>
                                                <p>The most popular business types for entrepreneurs in India balance liability, compliance, and control.</p>
                                                </a>
                                            </li>
                                            <li data-list="2" class="">
                                                <a href="javascript:void(0);" bis_skin_checked="1">
                                                <img src="<?php echo e(asset('frontend/images/menu_icon/icon2.svg'), false); ?>" alt="icon"> Special Business Types <i class="fa-regular fa-chevron-right"></i>
                                                <p>These registrations serve unique purposes or goals under specific legal frameworks.</p>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="submenu_middle" bis_skin_checked="1">
                                        <div class="menu_sublist" data-menu="1" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="private-limited-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon3.svg'), false); ?>" alt="icon"> Private Limited Registration</a></li>
                                                <li><a href="public-limited-company-registration.php"><i class="fa-regular fa-city" style="color: #111112;"></i> Public Limited Company</a></li>
                                                <li><a href="llp-registration.php"><i class="fa-regular fa-handshake"></i> LLP Registration</a></li>
                                                <li><a href="partnership-firm-registration.php"><i class="fa-regular fa-users"></i> Partnership Firm Registration</a></li>
                                                <li><a href="llp-registration.php"><i class="fa-regular fa-user-tie"></i> One Person Company Registration</a></li>
                                                <li><a href="register-sole-proprietorship-firm-in-india.php"><i class="fa-regular fa-user"></i> Sole Proprietorship Firm</a></li>
                                            </ul>
                                        </div>
                                        <div class="menu_sublist active" data-menu="2" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="foreign-company-registration-in-india.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon6.svg'), false); ?>" alt="icon"> Foreign Company Registration</a></li>
                                                <li><a href="online-trust-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon7.svg'), false); ?>" alt="icon"> Trust Registration</a></li>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon8.svg'), false); ?>" alt="icon"> Section 8 Company Registration</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="submenu_right" bis_skin_checked="1">
                                        <img src="<?php echo e(asset('frontend/images/service-img01.jpg'), false); ?>" alt="img">
                                    </div>
                                    </div>
                                </li>
                                <li class="drop_down">
                                    <a href="javascript:void(0);" bis_skin_checked="1">Registration & Filings</a>
                                    <ul class="mobile_menu">
                                    <li data-list="1">
                                        <a href="javascript:void(0);" bis_skin_checked="1">
                                        Intellectual Property  <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="llp-registration.php">  Trademark (TM) Registration</a></li>
                                        </ul>
                                    </li>
                                    <li data-list="2" class="">
                                        <a href="javascript:void(0);" bis_skin_checked="1">  Registrations  <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="GST.php"> GST Registration</a></li>
                                            <li><a href="llp-registration.php"> IEC Registration</a></li>
                                            <li><a href="llp-registration.php"> ESI Registration</a></li>
                                            <li><a href="llp-registration.php"> MSME Registration</a></li>
                                            <li><a href="llp-registration.php"> FSSAI Registration</a></li>
                                            <li><a href="public-limited-company-registration.php"> EPF Registration</a></li>
                                        </ul>
                                    </li>
                                    <li data-list="3" class="">
                                        <a href="javascript:void(0);" bis_skin_checked="1">Filings  <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="GST.php">Income Tax Return</a></li>
                                            <li><a href="GST.php">TDS Return</a></li>
                                        </ul>
                                    </li>
                                    <li data-list="4" class="">
                                        <a href="javascript:void(0);" bis_skin_checked="1"> Others  <i class="fa-regular fa-chevron-right"></i>
                                        </a>
                                        <ul class="mobile_menu">
                                            <li><a href="llp-registration.php"> Documentation</a></li>
                                        </ul>
                                    </li>
                                    </ul>
                                    <div class="submenu" bis_skin_checked="1">
                                    <div class="submenu_left" bis_skin_checked="1">
                                        <ul>
                                            <li data-list="1" class="">
                                                <a href="javascript:void(0);" bis_skin_checked="1">
                                                <img src="<?php echo e(asset('frontend/images/menu_icon/icon9.svg'), false); ?>" alt="icon"> Intellectual Property <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                            </li>
                                            <li data-list="2" class="active">
                                                <a href="javascript:void(0);" bis_skin_checked="1"><img src="<?php echo e(asset('frontend/images/menu_icon/icon10.svg'), false); ?>" alt="icon"> Registrations <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                            </li>
                                            <li data-list="3">
                                                <a href="javascript:void(0);" bis_skin_checked="1"><img src="<?php echo e(asset('frontend/images/menu_icon/icon10.svg'), false); ?>" alt="icon"> Filings <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                            </li>
                                            <li data-list="4">
                                                <a href="javascript:void(0);" bis_skin_checked="1"><img src="<?php echo e(asset('frontend/images/menu_icon/icon10.svg'), false); ?>" alt="icon"> Others <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="submenu_middle" bis_skin_checked="1">
                                        <div class="menu_sublist" data-menu="1" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="javascript:void(0);"><img src="<?php echo e(asset('frontend/images/menu_icon/icon11.svg'), false); ?>" alt="icon"> Trademark (TM) Registration</a></li>
                                            </ul>
                                        </div>
                                        <div class="menu_sublist active" data-menu="2" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="GST.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon14.svg'), false); ?>" alt="icon"> GST Registration</a></li>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon15.svg'), false); ?>" alt="icon"> IEC Registration</a></li>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon8.svg'), false); ?>" alt="icon"> ESI Registration</a></li>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon16.svg'), false); ?>" alt="icon"> MSME Registration</a></li>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon17.svg'), false); ?>" alt="icon"> FSSAI Registration</a></li>
                                                <li><a href="online-epf-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon15.svg'), false); ?>" alt="icon"> EPF Registration</a></li>
                                            </ul>
                                        </div>
                                        <div class="menu_sublist" data-menu="3" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="GST.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon14.svg'), false); ?>" alt="icon"> Income Tax Return</a></li>
                                                <li><a href="llp-registration.php"> <i class="fas fa-file-invoice-dollar"></i> TDS Return</a></li>
                                            </ul>
                                        </div>
                                        <div class="menu_sublist" data-menu="4" bis_skin_checked="1">
                                            <ul>
                                                <li><a href="llp-registration.php"><img src="<?php echo e(asset('frontend/images/menu_icon/icon1.svg'), false); ?>" alt="icon"> Documentation</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="submenu_right" bis_skin_checked="1">
                                        <img src="<?php echo e(asset('frontend/images/service-img03.jpg'), false); ?>" alt="img">
                                    </div>
                                    </div>
                                </li>
                                <li><a href="GST.php" bis_skin_checked="1">GST</a></li>
                                <li><a href="accounting-and-bookkeeping.php" bis_skin_checked="1">Accounting and Bookkeeping</a></li>
                                <li><a href="blog.php" bis_skin_checked="1">Blog</a></li>
                                <li><a href="annual-compliances.php" bis_skin_checked="1">Compliances</a></li>
                                <li><a href="virtual-cfo.php" bis_skin_checked="1">Virtual CFO</a></li>
                            </ul>
                            <a href="https://dashboard.topfilings.com/authentication/login" class="login_menu">
                            <span>Client Login</span>
                            </a>
                        </nav> -->
                        <nav>
                            <ul>
                                <!-- Home Link -->
                                <li><a href="/" class="<?php echo e(Request::is('/') ? 'active' : '', false); ?>" bis_skin_checked="1">Home</a></li>
                                
                                <!-- Start a Business Dropdown -->
                                <li class="drop_down">
                                    <a href="javascript:void(0);" bis_skin_checked="1">Start a Business</a>
                                    <ul class="mobile_menu">
                                        <?php $sab_count = 0; ?>
                                        <?php $__currentLoopData = $header_nav['start_a_business']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(!empty($side_nav['title'])): ?>
                                            <li data-list="<?php echo e($sab_count + 1, false); ?>" class="<?php echo e($sab_count == 0 ? 'active' : '', false); ?>">
                                                <a href="javascript:void(0);" bis_skin_checked="1">
                                                    <?php echo e($side_nav['title'], false); ?> <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                                <ul class="mobile_menu">
                                                    <?php $__currentLoopData = $side_nav['nav_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page_key => $page_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!empty($page_id)): ?>
                                                            <li><a href="<?php echo e(getPageUrl($page_id), false); ?>"> <?php echo e(getPageTitle($page_id), false); ?></a></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>
                                            <?php $sab_count++; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <div class="submenu" bis_skin_checked="1">
                                        <div class="submenu_left" bis_skin_checked="1">
                                            <ul>
                                                <?php $sab_count = 0; ?>
                                                <?php $__currentLoopData = $header_nav['start_a_business']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!empty($side_nav['title'])): ?>
                                                    <li data-list="<?php echo e($sab_count + 1, false); ?>" class="<?php echo e($sab_count == 1 ? 'active' : '', false); ?>">
                                                        <a href="javascript:void(0);" bis_skin_checked="1">
                                                            <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($sab_count + 1) . '.svg'), false); ?>" alt="icon">  
                                                            <?php echo e($side_nav['title'], false); ?>  <i class="fa-regular fa-chevron-right"></i>
                                                            <?php if(!empty($side_nav['paragraph'])): ?>
                                                            <p><?php echo e($side_nav['paragraph'], false); ?></p>
                                                            <?php endif; ?>
                                                        </a>
                                                    </li>
                                                    <?php $sab_count++; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                        <div class="submenu_middle" bis_skin_checked="1">
                                            <?php $sab_count = 0; ?>
                                            <?php $__currentLoopData = $header_nav['start_a_business']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($side_nav['title'])): ?>
                                                <div class="menu_sublist <?php echo e($sab_count == 1 ? 'active' : '', false); ?>" data-menu="<?php echo e($sab_count + 1, false); ?>" bis_skin_checked="1">
                                                    <ul>
                                                        <?php $item_count = 0; ?>
                                                        <?php $__currentLoopData = $side_nav['nav_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page_key => $page_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!empty($page_id)): ?>
                                                            <li>
                                                                <a href="<?php echo e(getPageUrl($page_id), false); ?>">
                                                                    <?php if($sab_count == 0): ?>
                                                                        <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($item_count + 3) . '.svg'), false); ?>" alt="icon">
                                                                    <?php else: ?>
                                                                        <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($item_count + 6) . '.svg'), false); ?>" alt="icon">
                                                                    <?php endif; ?>
                                                                    <?php echo e(getPageTitle($page_id), false); ?>

                                                                </a>
                                                            </li>
                                                            <?php $item_count++; ?>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                                <?php $sab_count++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="submenu_right" bis_skin_checked="1">
                                            <img src="<?php echo e(asset('frontend/images/service-img01.jpg'), false); ?>" alt="img">
                                        </div>
                                    </div>
                                </li>
                                
                                <!-- Registration & Filings Dropdown -->
                                <li class="drop_down">
                                    <a href="javascript:void(0);" bis_skin_checked="1">Registration & Filings</a>
                                    <ul class="mobile_menu">
                                        <?php $raf_count = 0; ?>
                                        <?php $__currentLoopData = $header_nav['registration_and_filings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(!empty($side_nav['title'])): ?>
                                            <li data-list="<?php echo e($raf_count + 1, false); ?>" class="<?php echo e($raf_count == 1 ? 'active' : '', false); ?>">
                                                <a href="javascript:void(0);" bis_skin_checked="1">
                                                    <?php echo e($side_nav['title'], false); ?>  <i class="fa-regular fa-chevron-right"></i>
                                                </a>
                                                <ul class="mobile_menu">
                                                    <?php $__currentLoopData = $side_nav['nav_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page_key => $page_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!empty($page_id)): ?>
                                                            <li><a href="<?php echo e(getPageUrl($page_id), false); ?>"> <?php echo e(getPageTitle($page_id), false); ?></a></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>
                                            <?php $raf_count++; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <div class="submenu" bis_skin_checked="1">
                                        <div class="submenu_left" bis_skin_checked="1">
                                            <ul>
                                                <?php $raf_count = 0; ?>
                                                <?php $__currentLoopData = $header_nav['registration_and_filings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!empty($side_nav['title'])): ?>
                                                    <li data-list="<?php echo e($raf_count + 1, false); ?>" class="<?php echo e($raf_count == 1 ? 'active' : '', false); ?>">
                                                        <a href="javascript:void(0);" bis_skin_checked="1">
                                                            <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($raf_count + 9) . '.svg'), false); ?>" alt="icon"> 
                                                            <?php echo e($side_nav['title'], false); ?> <i class="fa-regular fa-chevron-right"></i>
                                                        </a>
                                                    </li>
                                                    <?php $raf_count++; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                        <div class="submenu_middle" bis_skin_checked="1">
                                            <?php $raf_count = 0; ?>
                                            <?php $__currentLoopData = $header_nav['registration_and_filings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $side_nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($side_nav['title'])): ?>
                                                <div class="menu_sublist <?php echo e($raf_count == 1 ? 'active' : '', false); ?>" data-menu="<?php echo e($raf_count + 1, false); ?>" bis_skin_checked="1">
                                                    <ul>
                                                        <?php $item_count = 0; ?>
                                                        <?php $__currentLoopData = $side_nav['nav_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page_key => $page_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!empty($page_id)): ?>
                                                            <li>
                                                                <a href="<?php echo e(getPageUrl($page_id), false); ?>">
                                                                    <?php if($raf_count == 0): ?>
                                                                        <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($item_count + 11) . '.svg'), false); ?>" alt="icon">
                                                                    <?php else: ?>
                                                                        <img src="<?php echo e(asset('frontend/images/menu_icon/icon' . ($item_count + 14) . '.svg'), false); ?>" alt="icon">
                                                                    <?php endif; ?>
                                                                    <?php echo e(getPageTitle($page_id), false); ?>

                                                                </a>
                                                            </li>
                                                            <?php $item_count++; ?>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                                <?php $raf_count++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="submenu_right" bis_skin_checked="1">
                                            <img src="<?php echo e(asset('frontend/images/service-img03.jpg'), false); ?>" alt="img">
                                        </div>
                                    </div>
                                </li>
                                
                                <!-- Other Menu Items -->
                                <?php for($i=0; $i<5; $i++){ 
                                    $page_url = getPageUrl($header_nav['page_'.$i]);
                                    $page_title = getPageTitle($header_nav['page_'.$i]);
                                ?>
                                <li><a href="<?php echo e($page_url, false); ?>" class="<?php echo e(Request::is($page_url) ? 'active' : '', false); ?>" bis_skin_checked="1"><?php echo e($page_title, false); ?></a></li>
                                <?php } ?>
                                
                            </ul>
                            <a href="https://dashboard.topfilings.com/authentication/login" class="login_menu">
                                <span>Client Login</span>
                            </a>
                        </nav>
                    </div>
                    <div class="menu_right">
                    <span class="menu_toggle"><i class="far fa-bars"></i></span>
                    <a href="https://dashboard.topfilings.com/authentication/login" class="login_btn">
                        <span>Client Login</span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="27" height="23" viewBox="0 0 27 23" fill="none">
                            <path d="M18.9036 0H8.09835C3.6325 0 0 3.63251 0 8.09835V10.2235C0 14.6883 3.6325 18.3208 8.09738 18.3208H8.41206L7.88759 21.1734C7.806 21.6202 8.0022 22.065 8.38876 22.3059C8.56844 22.4176 8.76852 22.473 8.96957 22.473C9.20073 22.473 9.43091 22.3992 9.62614 22.2535L14.8884 18.3218H18.9026C23.3675 18.3218 27 14.6893 27 10.2244V8.09835C27.001 3.63251 23.3685 0 18.9036 0ZM25.2527 10.2225C25.2527 13.7239 22.404 16.5726 18.9026 16.5726H14.598C14.4096 16.5726 14.226 16.6338 14.0745 16.7464L9.90683 19.8603L10.3216 17.6041C10.3682 17.3486 10.2992 17.0864 10.1331 16.8863C9.96705 16.6872 9.72132 16.5716 9.462 16.5716H8.09738C4.59599 16.5716 1.74729 13.7229 1.74729 10.2215V8.09835C1.74729 4.59696 4.59599 1.74826 8.09738 1.74826H18.9026C22.404 1.74826 25.2527 4.59696 25.2527 8.09835V10.2225Z" fill="#0f55dc"></path>
                            <path d="M8.39173 7.75342C7.61473 7.75342 6.98535 8.38279 6.98535 9.1598C6.98535 9.93681 7.61473 10.5662 8.39173 10.5662C9.16874 10.5662 9.79811 9.93681 9.79811 9.1598C9.79714 8.38279 9.16777 7.75342 8.39173 7.75342Z" fill="#0f55dc"></path>
                            <path d="M13.5006 7.75342C12.7236 7.75342 12.0942 8.38279 12.0942 9.1598C12.0942 9.93681 12.7236 10.5662 13.5006 10.5662C14.2776 10.5662 14.907 9.93681 14.907 9.1598C14.907 8.38279 14.2776 7.75342 13.5006 7.75342Z" fill="#0f55dc"></path>
                            <path d="M18.6095 7.75342C17.8325 7.75342 17.2031 8.38279 17.2031 9.1598C17.2031 9.93681 17.8325 10.5662 18.6095 10.5662C19.3865 10.5662 20.0159 9.93681 20.0159 9.1598C20.0159 8.38279 19.3865 7.75342 18.6095 7.75342Z" fill="#0f55dc"></path>
                        </svg>
                    </a>
                    </div>
                </div>
            </header>
        <?php endif; ?>
        <!--=================|| Header End ||============================-->

        <?php echo $__env->yieldContent('content'); ?>

        <!--=================|| Footer Start ||============================-->
        <footer class="footer pt60">
        <div class="container">
            <div class="footer_inner">
                <div class="footer-contact-wrapper">
                    <div class="contact-item">
                    <div class="contact-icon-email">
                        <span>
                            <!-- Email SVG -->
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M2 8.5C2 5 4 3.5 7 3.5H17C20 3.5 22 5 22 8.5V15.5C22 19 20 20.5 17 20.5H7" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M17 9L13.87 11.5C12.84 12.32 11.15 12.32 10.12 11.5L7 9" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M2 16.5H8" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M2 12.5H5" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="contact-details">
                        <p class="contact-label">Write to us</p>
                        <h4 class="contact-value"><?php echo e(getEmailAddress(), false); ?></h4>
                    </div>
                    </div>
                    <div class="contact-item">
                    <div class="contact-icon-phone">
                        <span>
                            <!-- Phone SVG -->
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M21.97 18.33C21.97 18.69 21.89 19.06 21.72 19.42C21.55 19.78 21.33 20.12 21.04 20.44C20.55 20.98 20.01 21.37 19.4 21.62C18.8 21.87 18.15 22 17.45 22C16.43 22 15.34 21.76 14.19 21.27C13.04 20.78 11.89 20.12 10.75 19.29C9.6 18.45 8.51 17.52 7.47 16.49C6.44 15.45 5.51 14.36 4.68 13.22C3.86 12.08 3.2 10.94 2.72 9.81C2.24 8.67 2 7.58 2 6.54C2 5.86 2.12 5.21 2.36 4.61C2.6 4 2.98 3.44 3.51 2.94C4.15 2.31 4.85 2 5.59 2C5.87 2 6.15 2.06 6.4 2.18C6.66 2.3 6.89 2.48 7.07 2.74L9.39 6.01C9.57 6.26 9.7 6.49 9.79 6.71C9.88 6.92 9.93 7.13 9.93 7.32C9.93 7.56 9.86 7.8 9.72 8.03C9.59 8.26 9.4 8.5 9.16 8.74L8.4 9.53C8.29 9.64 8.24 9.77 8.24 9.93C8.24 10.01 8.25 10.08 8.27 10.16C8.3 10.24 8.33 10.3 8.35 10.36C8.53 10.69 8.84 11.12 9.28 11.64C9.73 12.16 10.21 12.69 10.73 13.22C11.27 13.75 11.79 14.24 12.32 14.69C12.84 15.13 13.27 15.43 13.61 15.61C13.66 15.63 13.72 15.66 13.79 15.69C13.87 15.72 13.95 15.73 14.04 15.73C14.21 15.73 14.34 15.67 14.45 15.56L15.21 14.81C15.46 14.56 15.7 14.37 15.93 14.25C16.16 14.11 16.39 14.04 16.64 14.04C16.83 14.04 17.03 14.08 17.25 14.17C17.47 14.26 17.7 14.39 17.95 14.56L21.26 16.91C21.52 17.09 21.7 17.3 21.81 17.55C21.91 17.8 21.97 18.05 21.97 18.33Z" stroke="white" stroke-width="2" stroke-miterlimit="10"></path>
                                <path d="M18.5 9C18.5 8.4 18.03 7.48 17.33 6.73C16.69 6.04 15.84 5.5 15 5.5" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M22 9C22 5.13 18.87 2 15 2" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="contact-details">
                        <p class="contact-label">Call Us (USA)</p>
                        <h4 class="contact-value"><?php echo e(getPhoneNumber(), false); ?></h4>
                    </div>
                    </div>
                    <div class="contact-item">
                    <div class="contact-icon-location">
                        <span>
                            <!-- Location SVG -->
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M11.9999 13.4299C13.723 13.4299 15.1199 12.0331 15.1199 10.3099C15.1199 8.58681 13.723 7.18994 11.9999 7.18994C10.2768 7.18994 8.87988 8.58681 8.87988 10.3099C8.87988 12.0331 10.2768 13.4299 11.9999 13.4299Z" stroke="white" stroke-width="2"></path>
                                <path d="M3.6202 8.49C5.5902 -0.169998 18.4202 -0.159997 20.3802 8.5C21.5302 13.58 18.3702 17.88 15.6002 20.54C13.5902 22.48 10.4102 22.48 8.3902 20.54C5.6302 17.88 2.4702 13.57 3.6202 8.49Z" stroke="white" stroke-width="2"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="contact-details">
                        <p class="contact-label">Our Office</p>
                        <h4 class="contact-value"><?php echo e(getAddress(), false); ?></h4>
                    </div>
                    </div>
                </div>
                <div class="footer_bottom">
                    <div class="footer_box">
                    <h3>Newsletter</h3>
                    <p>Sign up to techco weekly newsletter to get the latest updates.</p>
                    <form action="#" method="post" class="subscribe_form">
                        <div class="form_box" bis_skin_checked="1">
                            <input type="email" name="email" placeholder="enter your email">
                            <button type="submit"><i class="fas fa-paper-plane"></i></button>
                        </div>
                    </form>
                    <p class="text_form">
                        By continuing, you agree to Top Filings <a href="<?php echo e(url('terms-conditions'), false); ?>">Terms of use</a> and <a href="<?php echo e(url('privacy-policy'), false); ?>">Privacy Policy</a>
                    </p>
                    </div>
                    <?php if(getFooterQuickLinks()): ?>
                    <div class="footer_box">
                        <h3>Quick Link</h3>
                        <ul class="menu_foot">
                            <?php $__empty_3 = true; $__currentLoopData = getFooterQuickLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_3 = false; ?>
                            <li><a href="<?php echo e(url(getPageUrl($item['page'])), false); ?>"><?php echo e(getPageTitle($item['page']), false); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                    <?php if(getFooterServiceLinks()): ?>
                    <div class="footer_box">
                    <h3> Services</h3>
                    <ul class="menu_foot">
                        <?php $__empty_4 = true; $__currentLoopData = getFooterServiceLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_4 = false; ?>
                            <li><a href="<?php echo e(url(getPageUrl($item['page'])), false); ?>"><?php echo e(getPageTitle($item['page']), false); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    </div>
                    <?php endif; ?>
                    <?php if(getFooterFeaturedServicesLinks()): ?>
                    <div class="footer_box">
                    <h3>Featured Services</h3>
                    <ul class="menu_foot">
                        <?php $__empty_5 = true; $__currentLoopData = getFooterFeaturedServicesLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_5 = false; ?>
                            <li><a href="<?php echo e(url(getPageUrl($item['page'])), false); ?>"><?php echo e(getPageTitle($item['page']), false); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="footer_copy_bottom">
            <div class="container">
                <div class="footer_copy">
                    <p>Copyright: © <span class="current_year"></span> <?php echo e(env('APP_NAME'), false); ?> <?php echo e(date('Y'), false); ?>. All Rights Reserved.</p>
                    <ul class="social_icon">
                        <li><a href="<?php echo e(getSocialLink('facebook'), false); ?>" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-facebook-f"></i></a></li>
                        <li><a href="<?php echo e(getSocialLink('instagram'), false); ?>" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-instagram"></i></a></li>
                        <li><a href="<?php echo e(getSocialLink('linked_in'), false); ?>" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-linkedin-in"></i></a></li>
                        <li><a href="<?php echo e(getSocialLink('tweeter_x'), false); ?>" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-x-twitter"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
        </footer>
        <!--=================|| Footer End ||============================-->
        <!--=================|| Modal Sec Start ||============================-->
        <!-- <div class="modal_sec" style="display: none;">
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form" data-modal="1">
                <span class="cross_btn"><i class="fa-solid fa-xmark"></i></span>
                <h3>Talk to Lawyer</h3>
                <p>Get professional legal advice and clear your doubts on contracts, litigation, and legal representation. In just 20 minutes, our verified legal expert will provide you with the guidance you need to protect your business.</p>
                <div class="form_inner">
                    <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                    <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                    <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                    <div class="form_box"><button type="submit">Talk to a Lawyer Now for ₹299</button></div>
                </div>
            </form>
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form" data-modal="2" style="display:none;">
                <span class="cross_btn"><i class="fa-solid fa-xmark"></i></span>
                <h3>Talk to Chartered Accountant</h3>
                <p>Receive expert financial advice on auditing, taxation, and financial planning. Our Chartered Accountant will provide tailored solutions in a focused 20-minute session to help you manage your business finances effectively.</p>
                <div class="form_inner">
                    <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                    <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                    <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                    <div class="form_box"><button type="submit">Talk to a CA Now for ₹299</button></div>
                </div>
            </form>
                <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form" data-modal="3" style="display:none;">
                <span class="cross_btn"><i class="fa-solid fa-xmark"></i></span>
                <h3>Talk to Company Secretary</h3>
                <p>Gain valuable insights on corporate governance and regulatory compliance. Our Company Secretary will guide you through the complexities of business regulations in a quick 20-minute consultation.</p>
                <div class="form_inner">
                    <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                    <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                    <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                    <div class="form_box"><button type="submit">Talk to a CS Now for ₹299</button></div>
                </div>
            </form>
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form" data-modal="4" style="display:none;">
                <span class="cross_btn"><i class="fa-solid fa-xmark"></i></span>
                <h3>Talk to Intellectual Property Lawyer</h3>
                <p>Protect your intellectual assets with expert advice on trademarks, copyrights, and patents. A dedicated IP Lawyer will assist you with rights enforcement and protection during your 20-minute session.</p>
                <div class="form_inner">
                    <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                    <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                    <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                    <div class="form_box"><button type="submit">Talk to an IP Lawyer Now for ₹299</button></div>
                </div>
            </form>
        </div> -->
        <div class="modal_overlay" style="display: none;"></div>
        <!--=================|| Modal Sec End ||============================-->
        <script src="<?php echo e(asset('frontend/js/owlcarousel.js'), false); ?>"></script>
        <script src="<?php echo e(asset('frontend/js/custom.js'), false); ?>"></script>
        <script src="<?php echo e(asset('frontend/js/smoth/lenis.min.js'), false); ?>"></script>
        <script>
        // Lenis ko initialize karein
            const lenis = new Lenis({
                duration: 1.2, // Scroll duration
                easing: (t) => Math.min(1, 1.001 - Math.pow(2, -10 * t)), // Easing function
                direction: 'vertical', // 'vertical' or 'horizontal'
                gestureDirection: 'vertical', // 'vertical' or 'horizontal'
                smooth: true,
                mouseMultiplier: 1,
                smoothTouch: false,
                touchMultiplier: 2,
                infinite: false,
            });
        
            // Animation frame loop for smooth rendering
            function raf(time) {
                lenis.raf(time);
                requestAnimationFrame(raf);
            }
        
            requestAnimationFrame(raf);
        
            // Optional: Smooth scroll for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    const targetId = this.getAttribute('href').substring(1);
                    const targetElement = document.getElementById(targetId);
                    if (targetElement) {
                        lenis.scrollTo(targetElement);
                    }
                });
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script>
            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success'), false); ?>");
            <?php endif; ?>

            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error'), false); ?>");
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    toastr.error("<?php echo e($error, false); ?>");
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </script>
    </body>
</html><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/layout.blade.php ENDPATH**/ ?>