@extends('frontend.layout')
@section('title','Home')
@section('content')

@php
   // Extract sections from the page data
   $heroSection = $page->sections->firstWhere('section_name', 'home_hero_section');
   $servicesSection = $page->sections->firstWhere('section_name', 'home_services_section');
   $choosingSection = $page->sections->firstWhere('section_name', 'home_choosing_topfilings_section');
   $counterSection = $page->sections->firstWhere('section_name', 'home_counter_section');
   $verifiedSection = $page->sections->firstWhere('section_name', 'home_verified_section');
   $blogSection = $page->sections->firstWhere('section_name', 'home_blog_section');
   $testimonialSection = $page->sections->firstWhere('section_name', 'home_testimonial_section');
@endphp

<!--=================|| Hero Sec start ||============================-->
@if($heroSection)
<section class="hero_sec">
    <div class="hero_slider owl-carousel owl-theme">
        @foreach($heroSection->section_json['images'] as $image)
        <div class="item" style="background-image:url('{{ asset('storage/' . $image) }}');">
            <div class="container">
                <div class="hero_content">
                    <h4>{{ $heroSection->section_json['sub_heading'] }}</h4>
                    <h1>{{ $heroSection->section_json['heading'] }}</h1>
                    <p>{{ $heroSection->section_json['paragraph'] }}</p>
                    <form class="form_hero" method="post" name="form_hero">
                        <div class="search_box">
                            <input type="search" name="search" value="" placeholder="Search services here.....">
                            <button type="submit"><img src="{{ asset('frontend/images/search.svg') }}" alt="search"/></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section>
@endif
<!--=================|| Hero Sec End ||============================-->

<!--=================|| Preferred Services Sec Start ||============================-->
@if($servicesSection)
<section class="preferred_sec ptb100">
    <div class="container">
        <div class="sec_head center_head">
            <h2>{{ $servicesSection->section_json['heading'] }}</h2>
            <p>{{ $servicesSection->section_json['sub_heading'] }}</p>
        </div>
        <div class="preferred_grid pt80">
            @foreach($servicesSection->section_json['cards'] as $index => $card)
            <div class="preferred_box {{ $index === 0 ? 'active' : '' }}">
                <h3><img src="{{ asset('frontend/images/icon1.svg') }}" alt="icon"> {{ $card['title'] }}</h3>
                <div class="preferred_img">
                    <img src="{{ asset('storage/' . $card['image']) }}" alt="{{ $card['title'] }}"/>
                </div>
                <div class="preferred_holder">
                    <h3><img src="{{ asset('frontend/images/icon1.svg') }}" alt="icon"> {{ $card['title'] }}</h3>
                    <p>{{ $card['description'] }}</p>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif
<!--=================|| Preferred Services Sec End ||============================-->

<!--=================|| Choosing Topfilings Sec Start ||============================-->
@if($choosingSection)
<section class="choosing_sec ptb100" style="background-image: url('{{ asset('frontend/images/service-img01.jpg') }}');">
    <div class="container">
        <div class="sec_head center_head">
            <h2>{{ $choosingSection->section_json['heading'] }}</h2>
            <p>{{ $choosingSection->section_json['sub_heading'] }}</p>
        </div>
        <div class="choosing_box">
            <div class="choosing_left">
                <ul>
                    @foreach($choosingSection->section_json['menus'] as $index => $menu)
                    <li class="{{ $index === 0 ? 'active' : '' }}" data-choose="{{ $index + 1 }}">
                        <span><img src="{{ asset('frontend/images/icons/icon' . ($index + 1) . '.svg') }}" alt="icon"/></span> 
                        {{ $menu['title'] }}
                    </li>
                    @endforeach
                </ul>
                <div class="active-bg mleave" style="top: 0px; height: 85px;"></div>
            </div>
            <div class="choosing_right">
                @foreach($choosingSection->section_json['menus'] as $index => $menu)
                <div class="choosing_content {{ $index === 0 ? 'active' : '' }}" data-content="{{ $index + 1 }}">
                    <img src="{{ asset('storage/' . $menu['image']) }}" alt="{{ $menu['title'] }}"/>
                    <p>{{ $menu['paragraph'] }}</p>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endif
<!--=================|| Choosing Topfilings Sec End ||============================-->

<!--=================|| Counter Sec Start ||============================-->
@if($counterSection)
<section class="counter_sec ptb100" style="background-color: #EAEEF0;">
    <div class="container">
        <div class="counter_grid">
            @foreach($counterSection->section_json['counters'] as $counter)
            <div class="counter_box">
                <h5 class="xb-item--title">{{ $counter['title'] }}</h5>
                <p class="xb-item--content">{{ $counter['paragraph'] }}</p>
                <span class="xb-item--number">{{ $counter['count'] }}</span>
                <span class="xb-item--text">{{ $counter['suffix'] }}</span>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif
<!--=================|| Counter Sec Start ||============================-->

<!--=================|| Verified CA, CS Sec Start ||============================-->
@if($verifiedSection)
<section class="verified_sec ptb100">
    <div class="container">
        <div class="sec_head center_head">
            <h2>{{ $verifiedSection->section_json['heading'] }}</h2>
        </div>
        <div class="main-content pt60">
            <div class="illustration-section">
                <img src="{{ asset('storage/' . $verifiedSection->section_json['image']) }}" alt="Expert Illustration">
            </div>
            <div class="cards-section">
                @foreach($verifiedSection->section_json['lists'] as $index => $item)
                <div class="card" data-form="{{ $index + 1 }}">
                    <div class="card-icon {{ strtolower(str_replace(' ', '-', explode(' ', $item['title'])[2] ?? 'lawyer')) }}">
                        <img src="{{ asset('storage/' . $item['icon']) }}" alt="{{ $item['title'] }} Icon">
                    </div>
                    <div class="card-content">
                        <h3>{{ $item['title'] }}</h3>
                        <p>{{ $item['paragraph'] }}</p>
                    </div>
                    <div class="arrow-icon"><i class="fa-solid fa-chevron-right"></i></div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
<!--=================|| Modal Sec Start ||============================-->
<div class="modal_sec" style="display: none;">
   @foreach($verifiedSection->section_json['lists'] as $index => $item)
   <form action="{{route('enquiry.store')}}" method="post" class="php-email-form" data-modal="{{$index + 1}}">
      @csrf
      <span class="cross_btn"><i class="fa-solid fa-xmark"></i></span>
      <h3>{{ $item['title'] }}</h3>
      <p>{{ $item['form_paragraph'] }}</p>
      <input type="hidden" name="type" value="{{ $item['title'] }}">
      <div class="form_inner">
            <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
            <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
            <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
            <div class="form_box"><button type="submit">Talk to a Lawyer Now for ₹299</button></div>
      </div>
   </form>
   @endforeach
</div>
<!--=================|| Modal Sec end ||============================-->
@endif

<!--=================|| Verified CA, CS Sec End ||============================-->

<!--=================|| Virtual CFO Sec Start ||============================-->
<section class="virtual_sec ptb100" style="background-color: #EAEEF0;">
   <div class="container">
      <div class="virtual_head pb60">
         <div class="sec_head">
            <h5>Online CFO in India</h5>
            <h2>Virtual CFO services</h2>
         </div>
         <a href="virtual-cfo.php" class="blue_btn">
         <span>View Virtual CFO</span>
         <i class="fa-regular fa-arrow-right"></i>
         </a>
      </div>
   </div>
      <div class="virtual_slider owl-carousel owl-theme">
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="26" height="30" viewBox="0 0 26 30" fill="none">
                        <g clip-path="url(#clip0_611_271)">
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0.272644 7.84181L13.0031 0L25.7336 7.84181V22.0318L22.3637 24.1077V9.70892L13.0031 3.94292L3.64251 9.70892V24.1077L0.272644 22.0318V7.84181ZM13.0031 26.8863L14.8752 25.7332V9.039L18.994 11.5761V23.196V25.766V26.1834L13.0031 29.8737L7.01236 26.1834V25.766V23.196V11.5761L11.131 9.039V25.7332L13.0031 26.8863Z" fill="#111112"></path>
                        </g>
                        <defs>
                           <clipPath id="clip0_611_271">
                              <rect width="26" height="30" fill="white"></rect>
                           </clipPath>
                        </defs>
                     </svg>
                  </div>
                  <h3>Financial Planning & Strategy</h3>
                  <p>Future-Ready Financial Roadmap</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/f_img.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none"><path d="M15 0H6.5933L6.57719 0.0292293L5.41696 2.14269H15C22.0985 2.14269 27.8567 7.89907 27.8567 15C27.8567 22.1009 22.1003 27.8573 15 27.8573C7.89967 27.8573 2.14269 22.1003 2.14269 15C2.1421 13.6568 2.35245 12.3218 2.76605 11.0439H5.22071C3.48063 15.3439 4.7536 20.276 8.35734 23.1968C11.9611 26.1176 17.0499 26.3416 20.8964 23.7487C24.7428 21.1559 26.4442 16.3547 25.0887 11.9184C23.7331 7.48217 19.6387 4.45191 15 4.4518H4.14996L2.97423 6.59389H15C18.7777 6.59466 22.0908 9.11575 23.0986 12.7566C24.1064 16.3974 22.5613 20.2632 19.3217 22.2065C16.0821 24.1497 11.9441 23.6928 9.20648 21.0896C6.46889 18.4864 5.80446 14.3765 7.58232 11.0433H10.3633C8.50705 13.2224 8.41726 16.3995 10.1475 18.68C11.8777 20.9604 14.9616 21.7296 17.5601 20.5288C20.1586 19.328 21.5713 16.4808 20.9559 13.6853C20.3404 10.8897 17.8625 8.8991 15 8.90062H1.70723L0.5309 11.0439C0.178785 12.3331 0.000243583 13.6636 0 15C0 23.2838 6.71558 30 15 30C23.2844 30 30 23.2838 30 15C30 6.71618 23.2838 0 15 0ZM15 11.0439C17.1849 11.0439 18.9561 12.8151 18.9561 15C18.9561 17.1849 17.1849 18.9561 15 18.9561C12.8151 18.9561 11.0439 17.1849 11.0439 15C11.0439 12.8151 12.8151 11.0439 15 11.0439Z" fill="#111112"></path></svg>
                  </div>
                  <h3>Business Growth & Budgeting</h3>
                  <p>Plan, Allocate, Grow Smartly</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/business.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none"><path d="M15 0H6.5933L6.57719 0.0292293L5.41696 2.14269H15C22.0985 2.14269 27.8567 7.89907 27.8567 15C27.8567 22.1009 22.1003 27.8573 15 27.8573C7.89967 27.8573 2.14269 22.1003 2.14269 15C2.1421 13.6568 2.35245 12.3218 2.76605 11.0439H5.22071C3.48063 15.3439 4.7536 20.276 8.35734 23.1968C11.9611 26.1176 17.0499 26.3416 20.8964 23.7487C24.7428 21.1559 26.4442 16.3547 25.0887 11.9184C23.7331 7.48217 19.6387 4.45191 15 4.4518H4.14996L2.97423 6.59389H15C18.7777 6.59466 22.0908 9.11575 23.0986 12.7566C24.1064 16.3974 22.5613 20.2632 19.3217 22.2065C16.0821 24.1497 11.9441 23.6928 9.20648 21.0896C6.46889 18.4864 5.80446 14.3765 7.58232 11.0433H10.3633C8.50705 13.2224 8.41726 16.3995 10.1475 18.68C11.8777 20.9604 14.9616 21.7296 17.5601 20.5288C20.1586 19.328 21.5713 16.4808 20.9559 13.6853C20.3404 10.8897 17.8625 8.8991 15 8.90062H1.70723L0.5309 11.0439C0.178785 12.3331 0.000243583 13.6636 0 15C0 23.2838 6.71558 30 15 30C23.2844 30 30 23.2838 30 15C30 6.71618 23.2838 0 15 0ZM15 11.0439C17.1849 11.0439 18.9561 12.8151 18.9561 15C18.9561 17.1849 17.1849 18.9561 15 18.9561C12.8151 18.9561 11.0439 17.1849 11.0439 15C11.0439 12.8151 12.8151 11.0439 15 11.0439Z" fill="#111112"></path></svg>
                  </div>
                  <h3>Break-Even & Profit Analysis</h3>
                  <p>Know Costs, Maximize Profits</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Break-Evens.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="20" height="32" viewBox="0 0 20 32" fill="none"><path d="M13.5569 9.84269C13.5569 5.2514 11.3429 1.29729 9.65666 0.0138936C9.65666 0.0138936 9.52695 -0.0584102 9.54037 0.126868C9.40171 8.99764 4.9155 11.4017 2.45099 14.6373C-3.23841 22.1117 2.04843 30.3047 7.44263 31.8185C10.4483 32.6681 6.74487 30.3182 6.26628 25.3609C5.68035 19.3777 13.5569 14.8045 13.5569 9.84269Z" fill="#111112"></path><path d="M16.1422 12.8659C16.1064 12.8433 16.0572 12.8252 16.0259 12.884C15.932 14.0002 14.8049 16.3862 13.3736 18.5824C8.52058 26.0207 11.2848 29.6087 12.8413 31.5383C13.7448 32.6545 12.8413 31.5383 15.0956 30.395C17.8821 28.6869 19.6892 25.7314 19.9575 22.4507C20.4003 17.1634 17.2604 13.833 16.1422 12.8659Z" fill="#111112"></path></svg>
                  </div>
                  <h3>MIS Reporting & Insights</h3>
                  <p>Track, Analyze, Make Decisions</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/MIS.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="26" height="30" viewBox="0 0 26 30" fill="none">
                        <g clip-path="url(#clip0_611_271)">
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0.272644 7.84181L13.0031 0L25.7336 7.84181V22.0318L22.3637 24.1077V9.70892L13.0031 3.94292L3.64251 9.70892V24.1077L0.272644 22.0318V7.84181ZM13.0031 26.8863L14.8752 25.7332V9.039L18.994 11.5761V23.196V25.766V26.1834L13.0031 29.8737L7.01236 26.1834V25.766V23.196V11.5761L11.131 9.039V25.7332L13.0031 26.8863Z" fill="#111112"></path>
                        </g>
                        <defs>
                           <clipPath id="clip0_611_271">
                              <rect width="26" height="30" fill="white"></rect>
                           </clipPath>
                        </defs>
                     </svg>
                  </div>
                  <h3>Startup CFO Support</h3>
                  <p>Strategic Support for Startups</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Startups.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="20" height="32" viewBox="0 0 20 32" fill="none"><path d="M13.5569 9.84269C13.5569 5.2514 11.3429 1.29729 9.65666 0.0138936C9.65666 0.0138936 9.52695 -0.0584102 9.54037 0.126868C9.40171 8.99764 4.9155 11.4017 2.45099 14.6373C-3.23841 22.1117 2.04843 30.3047 7.44263 31.8185C10.4483 32.6681 6.74487 30.3182 6.26628 25.3609C5.68035 19.3777 13.5569 14.8045 13.5569 9.84269Z" fill="#111112"></path><path d="M16.1422 12.8659C16.1064 12.8433 16.0572 12.8252 16.0259 12.884C15.932 14.0002 14.8049 16.3862 13.3736 18.5824C8.52058 26.0207 11.2848 29.6087 12.8413 31.5383C13.7448 32.6545 12.8413 31.5383 15.0956 30.395C17.8821 28.6869 19.6892 25.7314 19.9575 22.4507C20.4003 17.1634 17.2604 13.833 16.1422 12.8659Z" fill="#111112"></path></svg>
                  </div>
                  <h3>Private Equity Advisory</h3>
                  <p>Secure Smart Equity Deals</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Private.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="26" height="30" viewBox="0 0 26 30" fill="none">
                        <g clip-path="url(#clip0_611_271)">
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0.272644 7.84181L13.0031 0L25.7336 7.84181V22.0318L22.3637 24.1077V9.70892L13.0031 3.94292L3.64251 9.70892V24.1077L0.272644 22.0318V7.84181ZM13.0031 26.8863L14.8752 25.7332V9.039L18.994 11.5761V23.196V25.766V26.1834L13.0031 29.8737L7.01236 26.1834V25.766V23.196V11.5761L11.131 9.039V25.7332L13.0031 26.8863Z" fill="#111112"></path>
                        </g>
                        <defs>
                           <clipPath id="clip0_611_271">
                              <rect width="26" height="30" fill="white"></rect>
                           </clipPath>
                        </defs>
                     </svg>
                  </div>
                  <h3>IPO Preparation & Support</h3>
                  <p>Get IPO-Ready Efficiently</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/IPO.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none"><path d="M15 0H6.5933L6.57719 0.0292293L5.41696 2.14269H15C22.0985 2.14269 27.8567 7.89907 27.8567 15C27.8567 22.1009 22.1003 27.8573 15 27.8573C7.89967 27.8573 2.14269 22.1003 2.14269 15C2.1421 13.6568 2.35245 12.3218 2.76605 11.0439H5.22071C3.48063 15.3439 4.7536 20.276 8.35734 23.1968C11.9611 26.1176 17.0499 26.3416 20.8964 23.7487C24.7428 21.1559 26.4442 16.3547 25.0887 11.9184C23.7331 7.48217 19.6387 4.45191 15 4.4518H4.14996L2.97423 6.59389H15C18.7777 6.59466 22.0908 9.11575 23.0986 12.7566C24.1064 16.3974 22.5613 20.2632 19.3217 22.2065C16.0821 24.1497 11.9441 23.6928 9.20648 21.0896C6.46889 18.4864 5.80446 14.3765 7.58232 11.0433H10.3633C8.50705 13.2224 8.41726 16.3995 10.1475 18.68C11.8777 20.9604 14.9616 21.7296 17.5601 20.5288C20.1586 19.328 21.5713 16.4808 20.9559 13.6853C20.3404 10.8897 17.8625 8.8991 15 8.90062H1.70723L0.5309 11.0439C0.178785 12.3331 0.000243583 13.6636 0 15C0 23.2838 6.71558 30 15 30C23.2844 30 30 23.2838 30 15C30 6.71618 23.2838 0 15 0ZM15 11.0439C17.1849 11.0439 18.9561 12.8151 18.9561 15C18.9561 17.1849 17.1849 18.9561 15 18.9561C12.8151 18.9561 11.0439 17.1849 11.0439 15C11.0439 12.8151 12.8151 11.0439 15 11.0439Z" fill="#111112"></path></svg>
                  </div>
                  <h3>Fundraising & Investor Pitching</h3>
                  <p>Pitch, Raise, Grow Confidently</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Fundraising.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="26" height="30" viewBox="0 0 26 30" fill="none">
                        <g clip-path="url(#clip0_611_271)">
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0.272644 7.84181L13.0031 0L25.7336 7.84181V22.0318L22.3637 24.1077V9.70892L13.0031 3.94292L3.64251 9.70892V24.1077L0.272644 22.0318V7.84181ZM13.0031 26.8863L14.8752 25.7332V9.039L18.994 11.5761V23.196V25.766V26.1834L13.0031 29.8737L7.01236 26.1834V25.766V23.196V11.5761L11.131 9.039V25.7332L13.0031 26.8863Z" fill="#111112"></path>
                        </g>
                        <defs>
                           <clipPath id="clip0_611_271">
                              <rect width="26" height="30" fill="white"></rect>
                           </clipPath>
                        </defs>
                     </svg>
                  </div>
                  <h3>Payroll & HR Management</h3>
                  <p>Streamlined Pay & Compliance</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Payroll.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none"><path d="M15 0H6.5933L6.57719 0.0292293L5.41696 2.14269H15C22.0985 2.14269 27.8567 7.89907 27.8567 15C27.8567 22.1009 22.1003 27.8573 15 27.8573C7.89967 27.8573 2.14269 22.1003 2.14269 15C2.1421 13.6568 2.35245 12.3218 2.76605 11.0439H5.22071C3.48063 15.3439 4.7536 20.276 8.35734 23.1968C11.9611 26.1176 17.0499 26.3416 20.8964 23.7487C24.7428 21.1559 26.4442 16.3547 25.0887 11.9184C23.7331 7.48217 19.6387 4.45191 15 4.4518H4.14996L2.97423 6.59389H15C18.7777 6.59466 22.0908 9.11575 23.0986 12.7566C24.1064 16.3974 22.5613 20.2632 19.3217 22.2065C16.0821 24.1497 11.9441 23.6928 9.20648 21.0896C6.46889 18.4864 5.80446 14.3765 7.58232 11.0433H10.3633C8.50705 13.2224 8.41726 16.3995 10.1475 18.68C11.8777 20.9604 14.9616 21.7296 17.5601 20.5288C20.1586 19.328 21.5713 16.4808 20.9559 13.6853C20.3404 10.8897 17.8625 8.8991 15 8.90062H1.70723L0.5309 11.0439C0.178785 12.3331 0.000243583 13.6636 0 15C0 23.2838 6.71558 30 15 30C23.2844 30 30 23.2838 30 15C30 6.71618 23.2838 0 15 0ZM15 11.0439C17.1849 11.0439 18.9561 12.8151 18.9561 15C18.9561 17.1849 17.1849 18.9561 15 18.9561C12.8151 18.9561 11.0439 17.1849 11.0439 15C11.0439 12.8151 12.8151 11.0439 15 11.0439Z" fill="#111112"></path></svg>
                  </div>
                  <h3>Digital Finance Transformation</h3>
                  <p>Upgrade Systems, Boost Accuracy</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Digital.png')}}" alt="img">
            </div>
         </div>
         <div class="virtual_box item">
            <div class="virtual_left">
               <div class="virtual_details">
                  <div class="xb-item-icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="26" height="30" viewBox="0 0 26 30" fill="none">
                        <g clip-path="url(#clip0_611_271)">
                           <path fill-rule="evenodd" clip-rule="evenodd" d="M0.272644 7.84181L13.0031 0L25.7336 7.84181V22.0318L22.3637 24.1077V9.70892L13.0031 3.94292L3.64251 9.70892V24.1077L0.272644 22.0318V7.84181ZM13.0031 26.8863L14.8752 25.7332V9.039L18.994 11.5761V23.196V25.766V26.1834L13.0031 29.8737L7.01236 26.1834V25.766V23.196V11.5761L11.131 9.039V25.7332L13.0031 26.8863Z" fill="#111112"></path>
                        </g>
                        <defs>
                           <clipPath id="clip0_611_271">
                              <rect width="26" height="30" fill="white"></rect>
                           </clipPath>
                        </defs>
                     </svg>
                  </div>
                  <h3>Policy & Process Setup</h3>
                  <p>Structure, Standardize, Scale Easily</p>
               </div>
               <a href="virtual-cfo.php" class="blue_btn">
               <span>View Virtual CFO</span>
               <i class="fa-regular fa-arrow-right"></i>
               </a>
            </div>
            <div class="virtual_right">
               <img src="{{asset('frontend/images/services/Policy.png')}}" alt="img">
            </div>
         </div>
      </div>
</section>
<!--=================|| Virtual CFO Sec End ||============================-->
<!--=================|| Our 2-step workflow Sec Start ||============================-->
<section class="ourstep_sec ptb100" style="background-color: var(--white);">
   <div class="container">
      <div class="ourtep_inner">
         <div class="ourtep_left">
            <div class="sec_head">
               <h2>Your Trusted Partner in Growth</h2>
               <p>We understand the challenges you face and are here to provide the essential support you need to thrive.</p>
            </div>
         </div>
         <div class="ourtep_right">
            <div class="ourtep_box">
               <span>01</span>
               <img loading="lazy" width="390" height="261" src="{{asset('frontend/images/image01.png')}}" alt="img"/>
               <div class="ourtep_content">
                  <h3>We've got your back!</h3>
                  <p>Fisrt and the most problem faced by everyone while doing a startup is high registration and compliance Fees, But at Topfilings we always try to provide every service at a price which everyone can afford.</p>
               </div>
            </div>
            <div class="ourtep_box">
               <span>02</span>
               <img loading="lazy" width="390" height="261" src="{{asset('frontend/images/image02.png')}}" alt="img"/>
               <div class="ourtep_content">
                  <h3>Will you be my CFO ?</h3>
                  <p>Not every start-up can afford a CFO, but the investment structuring, equity / option allocation, spending, and human resource decisions you make in the early stages of your business can make or break you.</p>
               </div>
            </div>
         </div>
      </div>
   </div>
   <img src="{{asset('frontend/images/process-shape01.png')}}" alt="img"class="img1"/>
   <img src="{{asset('frontend/images/process-shape02.png')}}" alt="img"class="img2"/>
</section>
<!--=================|| Our 2-step workflow Sec End ||============================-->

<!--=================|| Blog Sec Start ||============================-->
@if($blogSection)
<section class="blog_sec ptb100" style="background-color: #EAEEF0;">
    <div class="container">
        <div class="sec_head center_head">
            <h2>{{ $blogSection->section_json['heading'] }}</h2>
            <p>{{ $blogSection->section_json['sub_heading'] }}</p>
        </div>
        <div class="blog_grid pt60">
            <!-- Blog posts would be dynamically loaded here -->
            <!-- You can add a loop for blog posts if you have them in your database -->
            @forelse($blogs as $blog)
            <a class="blog_box" href="{{url('/blog/'.$blog->slug)}}">
                <div class="featured_img"><img src="{{ asset('storage/'.$blog->feature_image) }}" alt="{{$blog->slug}}"/></div>
                <div class="blog_details">
                    <ul>
                        <li><span><img decoding="async" src="https://wp.xpressbuddy.com/innomax/wp-content/plugins/innomax-core/assets/img/profile-circle.svg" alt=""></span>By admin</li>
                        @php
                           $created_at = \Carbon\Carbon::parse($blog->created_at)->format('d M Y');
                        @endphp
                        <li><span><img decoding="async" src="https://wp.xpressbuddy.com/innomax/wp-content/plugins/innomax-core/assets/img/note.svg" alt=""></span>{{$created_at}}</li>
                    </ul>
                    <h3>{{$blog->title}}</h3>
                    <p>{{$blog->description}}</p>
                </div>
            </a>
            @endforeach
            <!-- Add more blog posts as needed -->
        </div>
    </div>
</section>
@endif
<!--=================|| Blog Sec Start ||============================-->

<!--=================|| Testimonial Sec Start ||============================-->
@if($testimonialSection)
<section class="testimonial_sec ptb100" style="background-image: url(frontend/images/testimonials.jpg);">
   <div class="container">
      <div class="sec_head center_head pb60">
         <h2>{{ $testimonialSection->section_json['heading'] }}</h2>
         <p>{{ $testimonialSection->section_json['sub_heading'] }}</p>
      </div>
   </div>
   <div class="testimonial_slider owl-carousel owl-theme">
      @forelse($testimonials as $item)
      <div class="item testimonial_box">
         <div class="testimonial_inner">
            <div class="testimonial_left">
               <img src="{{ asset('storage/'.$item->image) }}" alt="img"/>
               <h3>{{$item->name}}</h3>
            </div>
            <div class="testimonial_right">
               <p>"{{$item->comment}}"</p>
            </div>
         </div>
         <div class="testimonial_bottom" style="color:gold;">
            {{str_repeat('★', $item->ratings) . str_repeat('☆', 5 - $item->ratings)}}
            <img src="{{asset('frontend/images/quat.png')}}" alt="img"/>
         </div>
      </div>
      @endforeach
   </div>
</section>
@endif
<!--=================|| Testimonial Sec End ||============================-->
<script>
   $(document).ready(function() {
        $('.cards-section .card[data-form]').on('click', function() {
          let formId = $(this).data('form');
           $('form[data-modal]').addClass("d_none").hide(0);
           $('form[data-modal="' + formId + '"]').show(0);
         });
       $('.cards-section .card').on('click', function(){
          $('.modal_overlay').fadeIn(100);
          $('.modal_sec').fadeIn(100);
        });
        $('.cross_btn, .modal_overlay').on('click', function(){
          $('.modal_sec').fadeOut(100);
          $('.modal_overlay').fadeOut(100);
        });
       var a = 0;
    $(window).scroll(function() {
      var oTop = $('.counter_sec').offset().top - window.innerHeight;
      if (a == 0 && $(window).scrollTop() > oTop) {
        $('.counter-value').each(function() {
          var $this = $(this),
            countTo = $this.attr('data-count');
          $({
            countNum: $this.text()
          }).animate({
              countNum: countTo
            },
            {
              duration: 2000,
              easing: 'swing',
              step: function() {
                $this.text(Math.floor(this.countNum));
              },
              complete: function() {
                $this.text(this.countNum);
                //alert('finished');
              }

            });
        });
        a = 1;
      }
  });
  });
</script>
@endsection