@extends('frontend.layout')
@section('title', 'GST')
@section('content')

@php
    // Extract sections from the page data
    $contentFormSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
    $whySection = $page->sections->firstWhere('section_name', 'service_why_section');
    $twoColumnSection = $page->sections->firstWhere('section_name', 'two_column_list');
    $iconBoxSection = $page->sections->firstWhere('section_name', 'service_icon_box');
@endphp

<!--=================|| About Us Sec start ||============================-->
@if($contentFormSection)
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $contentFormSection->section_json['sub_heading'] }}</h5>
               <h2>{{ $contentFormSection->section_json['heading'] }}</h2>
               <p>{{ $contentFormSection->section_json['paragraph'] }}</p>
               <ul class="hero-features">
                  @for($i = 0; $i < 3; $i++)
                     @if(!empty($contentFormSection->section_json["list_$i"]))
                     <li><i class="fa-regular fa-circle-check"></i> {{ $contentFormSection->section_json["list_$i"] }}</li>
                     @endif
                  @endfor
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="{{route('enquiry.store')}}" method="post" class="php-email-form">
               @csrf
               <h3>{{ $contentFormSection->section_json['form_heading'] }}</h3>
               <p>{{ $contentFormSection->section_json['form_sub_heading'] }}</p>
               <input type="hidden" name="type" value="{{ $contentFormSection->section_json['form_heading'] }}">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit">{{ $contentFormSection->section_json['form_button_text'] }}</button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
@endif
<!--=================|| About Us start ||============================-->

<!--=================|| Why Private Limited  start ||============================-->
@if($whySection && !empty($whySection->section_table))
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h5>{{ $whySection->section_json['sub_heading'] }}</h5>
         <h2>{{ $whySection->section_json['heading'] }}</h2>
      </div>
      <div class="why_grid pt40">
         @foreach($whySection->section_table as $item)
            @if(is_array($item) && !empty($item['title']))
            <div class="service-box">
               <div class="service-item">
                  <h3 class="xb-item--title">{{ $item['title'] }}</h3>
                  <p class="xb-item-contact">{{ $item['paragraph'] }}</p>
                  @if(!empty($item['icon']))
                  <div class="xb-item--img">
                     <img loading="lazy" decoding="async" width="640" height="640" src="{{ asset('storage/' . $item['icon']) }}" class="attachment-full size-full" alt="{{ $item['title'] }}">
                  </div>
                  @endif
               </div>
            </div>
            @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Why Private Limited  End ||============================-->

<!--=================|| Online Company Registration  Start ||============================-->
@if($twoColumnSection)
<section class="document_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2>{{ $twoColumnSection->section_json['heading'] }}</h2>
      </div>
      <div class="steps-wrapper pt40">
         @if(!empty($twoColumnSection->section_json['list_1']))
         <div class="step-item">
            <h3>{{ $twoColumnSection->section_json['list_1']['heading'] }}</h3>
            <ul>
               @for($i = 0; $i < 5; $i++)
                  @if(!empty($twoColumnSection->section_json['list_1']["item_$i"]))
                  <li>{{ $twoColumnSection->section_json['list_1']["item_$i"] }}</li>
                  @endif
               @endfor
            </ul>
         </div>
         @endif
         
         @if(!empty($twoColumnSection->section_json['list_2']))
         <div class="step-item">
            <h3>{{ $twoColumnSection->section_json['list_2']['heading'] }}</h3>
            <ul>
               @for($i = 0; $i < 5; $i++)
                  @if(!empty($twoColumnSection->section_json['list_2']["item_$i"]))
                  <li>{{ $twoColumnSection->section_json['list_2']["item_$i"] }}</li>
                  @endif
               @endfor
            </ul>
         </div>
         @endif
      </div>
   </div>
</section>
@endif
<!--=================|| Online Company Registration  End ||============================-->

<!--=================|| Documents Required  Start ||============================-->
@if($iconBoxSection && !empty($iconBoxSection->section_table))
<section class="document_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2>{{$iconBoxSection->section_json['heading']}}</h2>
      </div>
      <div class="featured_grid pt40">
         @foreach($iconBoxSection->section_table as $item)
            @if(is_array($item) && !empty($item['title']))
            <div class="feature-box">
               <div class="icon-container">
                  @if(!empty($item['icon']))
                  <i class="{{ $item['icon'] }}"></i>
                  @endif
               </div>
               <h4>{{ $item['title'] }}</h4>
               <p>{{ $item['paragraph'] }}</p>
            </div>
            @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Documents Required  End ||============================-->

@endsection