@extends('frontend.layout')
@section('title', $page->name)
@section('content')

@php
    $pageData = $page->page_json;
@endphp

<!--=================|| About Us Sec start ||============================-->
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $page->name }}</h5>
               <h2>{{ $pageData['heading'] ?? 'Don\'t hesitate to reach out to us' }}</h2>
               <p>{{ $pageData['sub_heading'] ?? 'We\'re here to help and answer any question you might have. We look forward to hearing from you' }}</p>
            </div>
         </div>
         <div class="about_right">
            @if(isset($pageData['image']))
                <img src="{{ asset('storage/' . $pageData['image']) }}" alt="Contact Us" style="margin-left: auto;"/>
            @else
                <img src="{{ asset('images/contact-img.png') }}" alt="Contact Us" style="margin-left: auto;"/>
            @endif
         </div>
      </div>
   </div>
</section>
<!--=================|| About Us start ||============================-->

<!--=================|| Contact US  start ||============================-->
<section class="contact_us_sec pb100">
   <div class="container">
      <div class="contact_grid">
         <div class="contact_left">
            <form action="#" method="post" class="php-email-form">
               @csrf
               <h3>{{ $pageData['form']['heading'] ?? 'Send us a message' }}</h3>
               <p>{{ $pageData['form']['sub_heading'] ?? 'Give us a chance to serve and bring magic to your brand.' }}</p>
               <div class="form_inner">
                 <div class="form_box">
                   <label for="name">Name</label>
                   <input type="text" name="name" id="name" placeholder="Your Name" required>
                 </div>
                 <div class="form_box">
                   <label for="email">Email</label>
                   <input type="email" name="email" id="email" placeholder="Your Email" required>
                 </div>
                 <div class="form_box">
                   <label for="company">Company</label>
                   <input type="text" name="company" id="company" placeholder="Your Company">
                 </div>
                 <div class="form_box">
                   <label for="number">Phone Number</label>
                   <input type="tel" name="phone" id="phone" placeholder="Your Number">
                 </div>
                 <div class="form_box">
                   <label for="message">Message</label>
                   <textarea name="message" id="message" placeholder="Your Message" rows="4"></textarea>
                 </div>
                 <div class="form_box">
                   <button type="submit">{{ $pageData['form']['button_text'] ?? 'Send us a message' }}</button>
                 </div>
               </div>
            </form>
         </div>
         <div class="contact_right">
            <h3>Contact Info</h3>
            <ul class="contact-top-info">
               <li><a href="tel:{{getPhoneNumber()}}" target="_blank"><i class="fa-solid fa-phone"></i> {{getPhoneNumber()}}</a></li>
               <li><a href="mailto:{{getEmailAddress()}}" target="_blank"><i class="fa-regular fa-envelope"></i> {{getEmailAddress()}}</a></li>
             </ul>
               <ul class="social_icon">
                  <li><a href="{{getSocialLink('facebook')}}" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-facebook-f"></i></a></li>
                  <li><a href="{{getSocialLink('instagram')}}" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-instagram"></i></a></li>
                  <li><a href="{{getSocialLink('linked_in')}}" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-linkedin-in"></i></a></li>
                  <li><a href="{{getSocialLink('tweeter_x')}}" target="_blank" bis_skin_checked="1"><i class="fa-brands fa-x-twitter"></i></a></li>
               </ul>
            <div class="contact-info_widget pt40">
               <h3 class="xb-title">India office</h3>
               <span class="xb-location">{{getAddress()}}</span>
            </div>
         </div>
      </div>
   </div>
</section>
<!--=================|| Contact US  End ||============================-->

@endsection