<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Page;
use App\Models\Blog;
use App\Models\Testimonial;
use App\Models\Enquiry;


class FrontEndController extends Controller
{
    static public function header(){
        $header_nav = Setting::where('name','header_nav')->first();
        return $header_nav;
    }

    public function page($slug = 'home')
    {
        $page = Page::where('slug', $slug)->with('sections')->first();
        \Log::info($page);
        if (!$page) {
            abort(404);
        }
        if ($page->slug == 'home') {
            $blogs = Blog::limit(4)->get();
            $testimonials = Testimonial::get();
            return view('frontend.home', compact('page', 'blogs', 'testimonials'));
        }
        if ($page->slug == 'gst') {
            \Log::info($page);
            return view('frontend.gst', compact('page'));
        }
        if ($page->slug == 'accounting-and-bookkeeping') {
            $blogs = Blog::limit(6)->get();
            return view('frontend.accounting-and-bookkeeping', compact('page','blogs'));
        }
        if ($page->slug == 'blogs') {
            $blogs = Blog::limit(6)->get();
            return view('frontend.blogs', compact('page','blogs'));
        }
        if ($page->slug == 'compliances') {
            $blogs = Blog::limit(6)->get();
            return view('frontend.compliances', compact('page','blogs'));
        }
        if ($page->slug == 'virtual-cfo') {
            return view('frontend.virtual-cfo', compact('page'));
        }
        if ($page->slug == 'about-us') {
            return view('frontend.about-us', compact('page'));
        }
        if ($page->slug == 'contact-us') {
            return view('frontend.contact-us', compact('page'));
        }

        $blogs = Blog::limit(6)->get();
        
        // Handle other pages if needed
        return view('frontend.page', compact('page', 'blogs'));
    }

    public function blog($slug)
    {
        $blog = Blog::where('slug', $slug)->first();
        \Log::info($blog);
        if (!$blog) {
            abort(404);
        }
        return view('frontend.blog-detail', compact('blog'));
    }

    public function storeEnquiry(Request $request){
        Enquiry::create($request->all());
        return back()->with('success', 'Your request submitted successfully, we will get back to you soon.');
    }

}
