<?php

use Illuminate\Support\Facades\Request;
use App\Models\Page;
use App\Models\Setting;

if (!function_exists('getFavIcon')) {
    function getFavIcon(){
        $favicon = Setting::where('name', 'site_favicon')->first();
        return $favicon ? '/storage/' . $favicon->value : null;
    }
}

if (!function_exists('getSiteLogo')) {
    function getSiteLogo(){
        $favicon = Setting::where('name', 'site_logo')->first();
        return $favicon ? '/storage/' . $favicon->value : null;
    }
}

if (!function_exists('getPageUrl')) {
    function getPageUrl($page_id){
        if($page_id !== null){
            $page = Page::findOrFail($page_id);
            return $page->slug;
        }
        return null;
    }
}

if(!function_exists('getPageTitle')){
    function getPageTitle($page_id){
        if($page_id !== null){
            $page = App\Models\Page::findOrFail($page_id);
            return $page->name;
        }
        return null;
    }
}

if(!function_exists('getEmailAddress')){
    function getEmailAddress(){
        $data = Setting::where('name', 'email')->first();
        return $data ? $data->value : null;
    }
}

if(!function_exists('getPhoneNumber')){
    function getPhoneNumber(){
        $data = Setting::where('name', 'phone')->first();
        return $data ? $data->value : null;
    }
}

function getAddress(){
    $data = Setting::where('name', 'address')->first();
    return $data ? $data->value : null;
}

function getFooterQuickLinks(){
    $data = Setting::where('name', 'footer_quick_links')->first();
    return $data ? $data->value : null;
}

function getFooterServiceLinks(){
    $data = Setting::where('name', 'footer_service_links')->first();
    return $data ? $data->value : null;
}

function getFooterFeaturedServicesLinks(){
    $data = Setting::where('name', 'footer_featured_services')->first();
    return $data ? $data->value : null;
}

if (!function_exists('getSocialLink')) {
    function getSocialLink($name)
    {
        $socialLinks = Setting::where('name', 'social_links')->first();
        if (!$socialLinks) {
            return null;
        }
        $links = $socialLinks->value;
        return $links[$name] ?? null;
    }
}