<?php

use Illuminate\Routing\Router;

Admin::routes();

Route::group([
    'prefix'        => config('admin.route.prefix'),
    'namespace'     => config('admin.route.namespace'),
    'middleware'    => config('admin.route.middleware'),
    'as'            => config('admin.route.prefix') . '.',
], function (Router $router) {
    $router->get('/', 'HomeController@index')->name('home');
    $router->resource('home-pages', HomePageController::class);
    $router->resource('blogs', BlogController::class);
    $router->resource('testimonials', TestimonialController::class);
    $router->resource('pages', PageController::class);
    $router->resource('page-sections', PageSectionController::class);
    $router->resource('section-templates', SectionTemplateController::class);
    $router->resource('settings', SettingController::class);
    $router->resource('enquiries', EnquiryController::class);
});