<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\HomePage;

class HomePageController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'HomePage';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new HomePage());

        $grid->column('id', __('Id'));
        $grid->column('hint_image', __('Hint Image'))->image('', 200, 100);
        $grid->column('section_name', __('Section Name'));
        $grid->column('section_json', __('Section JSON'))->display(function ($value) {
            return '<pre style="white-space: pre-wrap; word-break: break-all;">' . json_encode($value, JSON_PRETTY_PRINT) . '</pre>';
        });
        $grid->column('updated_at', __('Updated at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        // $grid->disableCreateButton();
        $grid->actions(function ($actions) {
            $actions->disableDelete();
            $actions->disableView();
        });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(HomePage::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('section_name', __('Service heading'));
        $show->field('section_json', __('Service sub heading'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */

    protected function form()
    {
        $form = new Form(new HomePage());

        if($form->isCreating()) {
            $form->text('section_name', 'Section Name')->required()->help('Use "services_section" for Services Section');
            $form->image('hint_image', 'Hint Image')
                    ->uniqueName()
                    ->move('home/section_hints')
                    ->help('Upload hint image for the section');
        }

        $form->editing(function (Form $form) {
            $form->divider($form->model()->section_name);
            if ($form->model()->hint_image) {
                $form->html('<img src="' . asset('storage/'.$form->model()->hint_image) . '" style="max-width:400px;" />', 'Current Hint Image');
            }
            // hero section -----------------------------------------------------------------------------
            if ($form->model()->section_name == 'hero_section') {
                $sectionJson = $form->model()->section_json;
                $form->embeds('section_json', 'Hero Section', function ($json) use($sectionJson) {
                    $json->textarea('sub_heading', 'Sub-heading')->required();
                    $json->text('heading', 'Heading')->required();
                    $json->textarea('paragraph', 'Paragraph')->required();
                    $json->multipleImage('images', 'Images')
                        ->uniqueName()
                        ->move('home/hero')
                        ->help('Upload images for the hero section')
                        ->value($sectionJson['images'] ?? null);
                    $json->hidden('current_images', 'Current Images')
                        ->default(isset($sectionJson['images']) ? json_encode($sectionJson['images']) : null)
                        ->readonly();
                });
            }
            // service section ---------------------------------------------------------------------------
            if ($form->model()->section_name == 'services_section') {
                $sectionJson = $form->model()->section_json;
                $form->embeds('section_json', 'Service Section', function ($json) use($sectionJson) {
                    $json->text('heading', 'Section Heading')->required();
                    $json->textarea('sub_heading', 'Sub-heading')->required();
                    
                    $json->embeds('cards', 'Cards', function ($json) use($sectionJson) {
                        for ($i = 0; $i < 3; $i++) {
                            $json->embeds($i, 'Card-'.$i, function ($json) use ($i, $sectionJson) {
                                $json->text('title', 'Title')->required();
                                $json->textarea('description', 'Description')->required();
                                $json->image('image', 'Image')
                                    ->uniqueName()
                                    ->move('home/cards')
                                    ->help('Upload card image')
                                    ->value($sectionJson['cards'][$i]['image'] ?? null);
                                if(isset($sectionJson['cards'][$i]['image'])) {
                                    $json->hidden('current_image', 'Current Image')
                                        ->default($sectionJson['cards'][$i]['image'])
                                        ->readonly();
                                }
                                
                                $json->url('link', 'Link')->placeholder('https://example.com');
                            });
                        }
                    });
                });
            }
            //choosing_topfilings section ---------------------------------------------------------------------------
            if ($form->model()->section_name == 'choosing_topfilings_section') {
                $sectionJson = $form->model()->section_json;
                $form->embeds('section_json', 'Choosing TopFilings Section', function ($json) use($sectionJson) {
                    $json->text('heading', 'Section Heading')->required();
                    $json->textarea('sub_heading', 'Sub-heading')->required();
                    $json->embeds('menus', 'Menus', function ($json) use($sectionJson) {
                        for ($i = 0; $i < 4; $i++) {
                            $json->embeds($i, 'Menu-'.$i, function ($json) use ($i, $sectionJson) {
                                $json->text('title', 'Title')->required();
                                $json->textarea('paragraph', 'Paragraph')->required();
                                $json->image('image', 'Image')
                                    ->uniqueName()
                                    ->move('home/choosing_topfilings')
                                    ->help('Upload menu image')
                                    ->value($sectionJson['cards'][$i]['image'] ?? null);
                                if(isset($sectionJson['menus'][$i]['image'])) {
                                    $json->hidden('current_image', 'Current Image')
                                        ->default($sectionJson['menus'][$i]['image'])
                                        ->readonly();
                                }
                            });
                        }
                    });
                });
            }
            // counter_section ---------------------------------------------------------------------------
            if ($form->model()->section_name == 'counter_section') {
                $form->embeds('section_json', 'Counter Section', function ($json){
                    $json->embeds('counters', 'Counters', function ($json) {
                        for ($i = 0; $i < 3; $i++) {
                            $json->embeds($i, 'Counter-'.$i, function ($json) {
                                $json->text('title', 'Title')->required();
                                $json->text('paragraph', 'Paragraph')->required();
                                $json->text('count', 'Count')->required();
                                $json->text('suffix', 'Suffix')->required();
                            });
                        }
                    });
                });
            }
            // verified_section ---------------------------------------------------------------------------
            if ($form->model()->section_name == 'verified_section') {
                $sectionJson = $form->model()->section_json;
                $form->embeds('section_json', 'Verified Section', function ($json) use($sectionJson) {
                    $json->text('heading', 'Section Heading')->required();
                    $json->image('image', 'Image')
                        ->uniqueName()
                        ->move('home/verified')
                        ->help('Upload image for the section')
                        ->value($sectionJson['image'] ?? null);
                    if(isset($sectionJson['image'])) {
                        $json->hidden('current_image', 'Current Image')
                            ->default($sectionJson['image'])
                            ->readonly();
                    }
                    $json->embeds('lists', 'Lists', function ($json) use($sectionJson) {
                        for ($i = 0; $i < 4; $i++) {
                            $json->embeds($i, 'List-'.$i, function ($json) use ($i, $sectionJson) {
                                $json->text('title', 'Title')->required();
                                $json->textarea('paragraph', 'Paragraph')->required();
                                $json->image('icon', 'Icon')
                                    ->uniqueName()
                                    ->move('home/verified/icons')
                                    ->help('Upload icon image')
                                    ->value($sectionJson['lists'][$i]['icon'] ?? null);
                                if(isset($sectionJson['lists'][$i]['icon'])) {
                                    $json->hidden('current_icon', 'Current Icon')
                                        ->default($sectionJson['lists'][$i]['icon'])
                                        ->readonly();
                                }
                                $json->textarea('form_paragraph', 'Form Paragraph')->required();
                                $json->text('button_text', 'Form Button Text')->required();
                            });
                        }
                    });
                });
            }
        });

        $form->saving(function (Form $form) {
            $form->model()->section_json = request('section_json');
        });

        return $form;
    }

}