<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\Blog;

class BlogController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Blog';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Blog());

        $grid->column('id', __('Id'));
        $grid->column('feature_image', __('Feature image'))->image('', 200, 100);
        $grid->column('title', __('Title'));
        $grid->column('description', __('Description'))->display(function ($description) {
            return substr(strip_tags($description), 0, 100) . '...';
        });
        $grid->column('tags', __('Tags'))->label();
        $grid->column('faq_json', __('Faq json'))->display(function ($faq) {
            if (empty($faq) || !is_array($faq)) return 'No FAQs';
            
            $count = count($faq);
            return $count . ' FAQ' . ($count !== 1 ? 's' : '');
        });
        $grid->column('created_at', __('Created at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });
        $grid->column('updated_at', __('Updated at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        return $grid;
    }


    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Blog::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('feature_image', __('Feature image'))->image();
        $show->field('title', __('Title'));
        $show->field('description', __('Description'))->unescape();
        $show->field('tags', __('Tags'))->label();
        $show->field('faq_json', __('Faq json'))->as(function ($faq) {
            if (empty($faq) || !is_array($faq)) return 'No FAQs';
            
            $html = '<div class="faq-container">';
            foreach ($faq as $index => $item) {
                $html .= '<div class="faq-item" style="margin-bottom: 20px; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">';
                $html .= '<h4 style="margin-top: 0; color: #333;">Q' . ($index . 1) . ': ' . ($item['question'] ?? '') . '</h4>';
                $html .= '<p style="margin-bottom: 0; color: #666;"><strong>A:</strong> ' . ($item['answer'] ?? '') . '</p>';
                $html .= '</div>';
            }
            $html .= '</div>';
            
            return $html;
        })->unescape();
        
        $show->field('created_at', __('Created at'))->as(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });
        $show->field('updated_at', __('Updated at'))->as(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Blog());
        $form->html(
                    '<style>
                        #has-many-faq_json{
                            overflow-x: auto;
                            width: 900px;
                        }
                        #has-many-faq_json table td{
                            min-width: 400px;
                        }
                        #has-many-faq_json table td.hidden{
                            min-width: 10px;
                        }
                        #has-many-faq_json table td .form-control.faq_json.answer{
                            width:600px;
                        }
                    }
                    </style>'
                );
        $form->image('feature_image', __('Feature image'));
        $form->text('title', __('Title'));
        $form->textarea('description', __('Description'));
        $form->tags('tags', __('Tags'));
        
        $form->table('faq_json', __('Faq json'), function ($table) {
            $table->textarea('question', 'Question');
            $table->textarea('answer', 'Answer');
        });

        return $form;
    }
}
